// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanIpprotectionMetrics_h
#define mozilla_GleanIpprotectionMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace ipprotection {
  /**
   * generated from ipprotection.click_upgrade_button
   */
  /**
   * This is recorded when a user clicks the upgrade button in the VPN panel.
   */
  constexpr impl::EventMetric<NoExtraKeys> click_upgrade_button(380);

  /**
   * generated from ipprotection.enabled
   * True if IP Protection is running.
   */
  constexpr impl::BooleanMetric enabled(381);

  /**
   * generated from ipprotection.error
   */
  struct ErrorExtra {
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the in-panel error message is triggered.
   */
  constexpr impl::EventMetric<ErrorExtra> error(382);

  /**
   * generated from ipprotection.toggled
   */
  struct ToggledExtra {
    mozilla::Maybe<nsCString> duration;
    mozilla::Maybe<bool> enabled;
    mozilla::Maybe<bool> useraction;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (duration) {
        extraKeys.AppendElement()->AssignASCII("duration");
        extraValues.EmplaceBack(duration.value());
      }
      if (enabled) {
        extraKeys.AppendElement()->AssignASCII("enabled");
        extraValues.AppendElement()->AssignASCII(enabled.value() ? "true" : "false");
      }
      if (useraction) {
        extraKeys.AppendElement()->AssignASCII("userAction");
        extraValues.AppendElement()->AssignASCII(useraction.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when IP Protection is toggled.
   */
  constexpr impl::EventMetric<ToggledExtra> toggled(383);

  /**
   * generated from ipprotection.usage_rx
   * Bytes transmitted (incoming) while IP Protection is running.
   */
  constexpr impl::MemoryDistributionMetric usage_rx(384);

  /**
   * generated from ipprotection.usage_tx
   * Bytes transmitted (outgoing) while IP Protection is running.
   */
  constexpr impl::MemoryDistributionMetric usage_tx(385);
}

} // namespace mozilla::glean

#endif // mozilla_GleanIpprotectionMetrics_h
