#ifndef mozilla_dom_BindingNames_h
#define mozilla_dom_BindingNames_h

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioDestinationNode = 335,
  AudioListener = 356,
  AudioNode = 370,
  AudioParam = 380,
  AudioParamMap = 391,
  AudioProcessingEvent = 405,
  AudioScheduledSourceNode = 426,
  AudioTrack = 451,
  AudioTrackList = 462,
  AudioWorklet = 477,
  AudioWorkletGlobalScope = 490,
  AudioWorkletNode = 514,
  AudioWorkletProcessor = 531,
  AuthenticatorAssertionResponse = 553,
  AuthenticatorAttestationResponse = 584,
  AuthenticatorResponse = 617,
  BarProp = 639,
  BaseAudioContext = 647,
  BatteryManager = 664,
  BeforeUnloadEvent = 679,
  BiquadFilterNode = 697,
  Blob = 714,
  BlobEvent = 719,
  BroadcastChannel = 729,
  BrowsingContext = 746,
  BrowsingContextGroup = 762,
  ByteLengthQueuingStrategy = 783,
  CDATASection = 809,
  CSS = 822,
  CSS2Properties = 826,
  CSSAnimation = 841,
  CSSConditionRule = 854,
  CSSContainerRule = 871,
  CSSCounterStyleRule = 888,
  CSSFontFaceRule = 908,
  CSSFontFeatureValuesRule = 924,
  CSSFontPaletteValuesRule = 949,
  CSSGroupingRule = 974,
  CSSImportRule = 990,
  CSSKeyframeRule = 1004,
  CSSKeyframesRule = 1020,
  CSSLayerBlockRule = 1037,
  CSSLayerStatementRule = 1055,
  CSSMediaRule = 1077,
  CSSMozDocumentRule = 1090,
  CSSNamespaceRule = 1109,
  CSSPageRule = 1126,
  CSSPropertyRule = 1138,
  CSSPseudoElement = 1154,
  CSSRule = 1171,
  CSSRuleList = 1179,
  CSSStyleDeclaration = 1191,
  CSSStyleRule = 1211,
  CSSStyleSheet = 1224,
  CSSSupportsRule = 1238,
  CSSTransition = 1254,
  Cache = 1268,
  CacheStorage = 1274,
  CallbackDebuggerNotification = 1287,
  CanonicalBrowsingContext = 1316,
  CanvasCaptureMediaStream = 1341,
  CanvasGradient = 1366,
  CanvasPattern = 1381,
  CanvasRenderingContext2D = 1395,
  CaretPosition = 1420,
  CaretStateChangedEvent = 1434,
  ChannelMergerNode = 1457,
  ChannelSplitterNode = 1475,
  ChannelWrapper = 1495,
  CharacterData = 1510,
  CheckerboardReportService = 1524,
  ChildProcessMessageManager = 1550,
  ChildSHistory = 1577,
  ChromeMessageBroadcaster = 1591,
  ChromeMessageSender = 1616,
  ChromeNodeList = 1636,
  ChromeUtils = 1651,
  ChromeWorker = 1663,
  Client = 1676,
  Clients = 1683,
  Clipboard = 1691,
  ClipboardEvent = 1701,
  ClipboardItem = 1716,
  ClonedErrorHolder = 1730,
  CloseEvent = 1748,
  CommandEvent = 1759,
  Comment = 1772,
  CompositionEvent = 1780,
  CompressionStream = 1797,
  ConsoleInstance = 1815,
  ConstantSourceNode = 1831,
  ContentFrameMessageManager = 1850,
  ContentProcessMessageManager = 1877,
  ContentVisibilityAutoStateChangeEvent = 1906,
  ConvolverNode = 1944,
  CountQueuingStrategy = 1958,
  CreateOfferRequest = 1979,
  Credential = 1998,
  CredentialsContainer = 2009,
  Crypto = 2030,
  CryptoKey = 2037,
  CustomElementRegistry = 2047,
  CustomEvent = 2069,
  DOMException = 2081,
  DOMImplementation = 2094,
  DOMLocalization = 2112,
  DOMMatrix = 2128,
  DOMMatrixReadOnly = 2138,
  DOMParser = 2156,
  DOMPoint = 2166,
  DOMPointReadOnly = 2175,
  DOMQuad = 2192,
  DOMRect = 2200,
  DOMRectList = 2208,
  DOMRectReadOnly = 2220,
  DOMRequest = 2236,
  DOMStringList = 2247,
  DOMStringMap = 2261,
  DOMTokenList = 2274,
  DataTransfer = 2287,
  DataTransferItem = 2300,
  DataTransferItemList = 2317,
  DebuggerNotification = 2338,
  DebuggerNotificationObserver = 2359,
  DecompressionStream = 2388,
  DedicatedWorkerGlobalScope = 2408,
  DelayNode = 2435,
  DeprecationReportBody = 2445,
  DeviceAcceleration = 2467,
  DeviceLightEvent = 2486,
  DeviceMotionEvent = 2503,
  DeviceOrientationEvent = 2521,
  DeviceRotationRate = 2544,
  Directory = 2563,
  Document = 2573,
  DocumentFragment = 2582,
  DocumentL10n = 2599,
  DocumentTimeline = 2612,
  DocumentType = 2629,
  DominatorTree = 2642,
  DragEvent = 2656,
  DynamicsCompressorNode = 2666,
  EXT_blend_minmax = 2689,
  EXT_color_buffer_float = 2706,
  EXT_color_buffer_half_float = 2729,
  EXT_disjoint_timer_query = 2757,
  EXT_float_blend = 2782,
  EXT_frag_depth = 2798,
  EXT_sRGB = 2813,
  EXT_shader_texture_lod = 2822,
  EXT_texture_compression_bptc = 2845,
  EXT_texture_compression_rgtc = 2874,
  EXT_texture_filter_anisotropic = 2903,
  EXT_texture_norm16 = 2934,
  Element = 2953,
  ElementInternals = 2961,
  ErrorEvent = 2978,
  Event = 2989,
  EventCallbackDebuggerNotification = 2995,
  EventCounts = 3029,
  EventSource = 3041,
  EventTarget = 3053,
  Exception = 3065,
  ExtendableEvent = 3075,
  ExtendableMessageEvent = 3091,
  ExtensionAlarms = 3114,
  ExtensionBrowser = 3130,
  ExtensionBrowserSettings = 3147,
  ExtensionBrowserSettingsColorManagement = 3172,
  ExtensionDns = 3212,
  ExtensionEventManager = 3225,
  ExtensionMockAPI = 3247,
  ExtensionPort = 3264,
  ExtensionProxy = 3278,
  ExtensionRuntime = 3293,
  ExtensionScripting = 3310,
  ExtensionSetting = 3329,
  ExtensionTest = 3346,
  External = 3360,
  FeaturePolicy = 3369,
  FeaturePolicyViolationReportBody = 3383,
  FetchEvent = 3416,
  FetchObserver = 3427,
  File = 3441,
  FileList = 3446,
  FileReader = 3455,
  FileReaderSync = 3466,
  FileSystem = 3481,
  FileSystemDirectoryEntry = 3492,
  FileSystemDirectoryHandle = 3517,
  FileSystemDirectoryHandle_AsyncIterator = 3543,
  FileSystemDirectoryIterator = 3583,
  FileSystemDirectoryReader = 3611,
  FileSystemEntry = 3637,
  FileSystemFileEntry = 3653,
  FileSystemFileHandle = 3673,
  FileSystemHandle = 3694,
  FileSystemSyncAccessHandle = 3711,
  FileSystemWritableFileStream = 3738,
  Flex = 3767,
  FlexItemValues = 3772,
  FlexLineValues = 3787,
  FluentBundle = 3802,
  FluentBundleAsyncIterator = 3815,
  FluentBundleIterator = 3841,
  FluentPattern = 3862,
  FluentResource = 3876,
  FocusEvent = 3891,
  FontFace = 3902,
  FontFaceSet = 3911,
  FontFaceSetIterator = 3923,
  FontFaceSetLoadEvent = 3943,
  FormData = 3964,
  FormData_Iterator = 3973,
  FormDataEvent = 3991,
  FrameCrashedEvent = 4005,
  FrameLoader = 4023,
  GPU = 4035,
  GPUAdapter = 4039,
  GPUAdapterInfo = 4050,
  GPUBindGroup = 4065,
  GPUBindGroupLayout = 4078,
  GPUBuffer = 4097,
  GPUBufferUsage = 4107,
  GPUCanvasContext = 4122,
  GPUColorWrite = 4139,
  GPUCommandBuffer = 4153,
  GPUCommandEncoder = 4170,
  GPUCompilationInfo = 4188,
  GPUCompilationMessage = 4207,
  GPUComputePassEncoder = 4229,
  GPUComputePipeline = 4251,
  GPUDevice = 4270,
  GPUDeviceLostInfo = 4280,
  GPUMapMode = 4298,
  GPUOutOfMemoryError = 4309,
  GPUPipelineLayout = 4329,
  GPUQuerySet = 4347,
  GPUQueue = 4359,
  GPURenderBundle = 4368,
  GPURenderBundleEncoder = 4384,
  GPURenderPassEncoder = 4407,
  GPURenderPipeline = 4428,
  GPUSampler = 4446,
  GPUShaderModule = 4457,
  GPUShaderStage = 4473,
  GPUSupportedFeatures = 4488,
  GPUSupportedLimits = 4509,
  GPUTexture = 4528,
  GPUTextureUsage = 4539,
  GPUTextureView = 4555,
  GPUUncapturedErrorEvent = 4570,
  GPUValidationError = 4594,
  GainNode = 4613,
  Gamepad = 4622,
  GamepadAxisMoveEvent = 4630,
  GamepadButton = 4651,
  GamepadButtonEvent = 4665,
  GamepadEvent = 4684,
  GamepadHapticActuator = 4697,
  GamepadLightIndicator = 4719,
  GamepadPose = 4741,
  GamepadServiceTest = 4753,
  GamepadTouch = 4772,
  Geolocation = 4785,
  GeolocationCoordinates = 4797,
  GeolocationPosition = 4820,
  GeolocationPositionError = 4840,
  GetUserMediaRequest = 4865,
  GleanCategory = 4885,
  GleanImpl = 4899,
  GleanLabeled = 4909,
  GleanPingsImpl = 4922,
  Grid = 4937,
  GridArea = 4942,
  GridDimension = 4951,
  GridLine = 4965,
  GridLines = 4974,
  GridTrack = 4984,
  GridTracks = 4994,
  HTMLAllCollection = 5005,
  HTMLAnchorElement = 5023,
  HTMLAreaElement = 5041,
  HTMLAudioElement = 5057,
  HTMLBRElement = 5074,
  HTMLBaseElement = 5088,
  HTMLBodyElement = 5104,
  HTMLButtonElement = 5120,
  HTMLCanvasElement = 5138,
  HTMLCollection = 5156,
  HTMLDListElement = 5171,
  HTMLDataElement = 5188,
  HTMLDataListElement = 5204,
  HTMLDetailsElement = 5224,
  HTMLDialogElement = 5243,
  HTMLDirectoryElement = 5261,
  HTMLDivElement = 5282,
  HTMLDocument = 5297,
  HTMLElement = 5310,
  HTMLEmbedElement = 5322,
  HTMLFieldSetElement = 5339,
  HTMLFontElement = 5359,
  HTMLFormControlsCollection = 5375,
  HTMLFormElement = 5402,
  HTMLFrameElement = 5418,
  HTMLFrameSetElement = 5435,
  HTMLHRElement = 5455,
  HTMLHeadElement = 5469,
  HTMLHeadingElement = 5485,
  HTMLHtmlElement = 5504,
  HTMLIFrameElement = 5520,
  HTMLImageElement = 5538,
  HTMLInputElement = 5555,
  HTMLLIElement = 5572,
  HTMLLabelElement = 5586,
  HTMLLegendElement = 5603,
  HTMLLinkElement = 5621,
  HTMLMapElement = 5637,
  HTMLMarqueeElement = 5652,
  HTMLMediaElement = 5671,
  HTMLMenuElement = 5688,
  HTMLMetaElement = 5704,
  HTMLMeterElement = 5720,
  HTMLModElement = 5737,
  HTMLOListElement = 5752,
  HTMLObjectElement = 5769,
  HTMLOptGroupElement = 5787,
  HTMLOptionElement = 5807,
  HTMLOptionsCollection = 5825,
  HTMLOutputElement = 5847,
  HTMLParagraphElement = 5865,
  HTMLParamElement = 5886,
  HTMLPictureElement = 5903,
  HTMLPreElement = 5922,
  HTMLProgressElement = 5937,
  HTMLQuoteElement = 5957,
  HTMLScriptElement = 5974,
  HTMLSelectElement = 5992,
  HTMLSlotElement = 6010,
  HTMLSourceElement = 6026,
  HTMLSpanElement = 6044,
  HTMLStyleElement = 6060,
  HTMLTableCaptionElement = 6077,
  HTMLTableCellElement = 6101,
  HTMLTableColElement = 6122,
  HTMLTableElement = 6142,
  HTMLTableRowElement = 6159,
  HTMLTableSectionElement = 6179,
  HTMLTemplateElement = 6203,
  HTMLTextAreaElement = 6223,
  HTMLTimeElement = 6243,
  HTMLTitleElement = 6259,
  HTMLTrackElement = 6276,
  HTMLUListElement = 6293,
  HTMLUnknownElement = 6310,
  HTMLVideoElement = 6329,
  HashChangeEvent = 6346,
  Headers = 6362,
  Headers_Iterator = 6370,
  HeapSnapshot = 6387,
  Highlight = 6400,
  HighlightRegistry = 6410,
  History = 6428,
  IDBCursor = 6436,
  IDBCursorWithValue = 6446,
  IDBDatabase = 6465,
  IDBFactory = 6477,
  IDBIndex = 6488,
  IDBKeyRange = 6497,
  IDBLocaleAwareKeyRange = 6509,
  IDBObjectStore = 6532,
  IDBOpenDBRequest = 6547,
  IDBRequest = 6564,
  IDBTransaction = 6575,
  IDBVersionChangeEvent = 6590,
  IIRFilterNode = 6612,
  IOUtils = 6626,
  IdentityCredential = 6634,
  IdleDeadline = 6653,
  Image = 6666,
  ImageBitmap = 6672,
  ImageBitmapRenderingContext = 6684,
  ImageCapture = 6712,
  ImageCaptureError = 6725,
  ImageCaptureErrorEvent = 6743,
  ImageData = 6766,
  ImageDocument = 6776,
  InputEvent = 6790,
  InspectorFontFace = 6801,
  InspectorUtils = 6819,
  InstallTriggerImpl = 6834,
  IntersectionObserver = 6853,
  IntersectionObserverEntry = 6874,
  IntlUtils = 6900,
  JSProcessActorChild = 6910,
  JSProcessActorParent = 6930,
  JSWindowActorChild = 6951,
  JSWindowActorParent = 6970,
  KeyEvent = 6990,
  KeyboardEvent = 6999,
  KeyframeEffect = 7013,
  L10nFileSource = 7028,
  L10nOverlays = 7043,
  L10nRegistry = 7056,
  LargestContentfulPaint = 7069,
  LegacyMozTCPSocket = 7092,
  Localization = 7111,
  Location = 7124,
  Lock = 7133,
  LockManager = 7138,
  MIDIAccess = 7150,
  MIDIConnectionEvent = 7161,
  MIDIInput = 7181,
  MIDIInputMap = 7191,
  MIDIMessageEvent = 7204,
  MIDIOutput = 7221,
  MIDIOutputMap = 7232,
  MIDIPort = 7246,
  MOZ_debug = 7255,
  MatchGlob = 7265,
  MatchPattern = 7275,
  MatchPatternSet = 7288,
  MathMLElement = 7304,
  MediaCapabilities = 7318,
  MediaCapabilitiesInfo = 7336,
  MediaControlService = 7358,
  MediaController = 7378,
  MediaDeviceInfo = 7394,
  MediaDevices = 7410,
  MediaElementAudioSourceNode = 7423,
  MediaEncryptedEvent = 7451,
  MediaError = 7471,
  MediaKeyError = 7482,
  MediaKeyMessageEvent = 7496,
  MediaKeySession = 7517,
  MediaKeyStatusMap = 7533,
  MediaKeyStatusMap_Iterator = 7551,
  MediaKeySystemAccess = 7578,
  MediaKeys = 7599,
  MediaList = 7609,
  MediaMetadata = 7619,
  MediaQueryList = 7633,
  MediaQueryListEvent = 7648,
  MediaRecorder = 7668,
  MediaRecorderErrorEvent = 7682,
  MediaSession = 7706,
  MediaSource = 7719,
  MediaStream = 7731,
  MediaStreamAudioDestinationNode = 7743,
  MediaStreamAudioSourceNode = 7775,
  MediaStreamError = 7802,
  MediaStreamEvent = 7819,
  MediaStreamTrack = 7836,
  MediaStreamTrackAudioSourceNode = 7853,
  MediaStreamTrackEvent = 7885,
  MerchantValidationEvent = 7907,
  MessageBroadcaster = 7931,
  MessageChannel = 7950,
  MessageEvent = 7965,
  MessageListenerManager = 7978,
  MessagePort = 8001,
  MessageSender = 8013,
  MimeType = 8027,
  MimeTypeArray = 8036,
  MouseEvent = 8050,
  MouseScrollEvent = 8061,
  MozCanvasPrintState = 8078,
  MozDocumentMatcher = 8098,
  MozDocumentObserver = 8117,
  MozQueryInterface = 8137,
  MozSharedMap = 8155,
  MozSharedMap_Iterator = 8168,
  MozSharedMapChangeEvent = 8190,
  MozStorageAsyncStatementParams = 8214,
  MozStorageStatementParams = 8245,
  MozStorageStatementRow = 8271,
  MozWritableSharedMap = 8294,
  MutationEvent = 8315,
  MutationObserver = 8329,
  MutationRecord = 8346,
  NamedNodeMap = 8361,
  NavigationPreloadManager = 8374,
  Navigator = 8399,
  NetworkInformation = 8409,
  Node = 8428,
  NodeFilter = 8433,
  NodeIterator = 8444,
  NodeList = 8457,
  Notification = 8466,
  NotificationEvent = 8479,
  NotifyPaintEvent = 8497,
  OES_draw_buffers_indexed = 8514,
  OES_element_index_uint = 8539,
  OES_fbo_render_mipmap = 8562,
  OES_standard_derivatives = 8584,
  OES_texture_float = 8609,
  OES_texture_float_linear = 8627,
  OES_texture_half_float = 8652,
  OES_texture_half_float_linear = 8675,
  OES_vertex_array_object = 8705,
  OVR_multiview2 = 8729,
  OfflineAudioCompletionEvent = 8744,
  OfflineAudioContext = 8772,
  OffscreenCanvas = 8792,
  OffscreenCanvasRenderingContext2D = 8808,
  Option = 8842,
  OscillatorNode = 8849,
  PageTransitionEvent = 8864,
  PaintRequest = 8884,
  PaintRequestList = 8897,
  PaintWorkletGlobalScope = 8914,
  PannerNode = 8938,
  ParentProcessMessageManager = 8949,
  Path2D = 8977,
  PathUtils = 8984,
  PaymentAddress = 8994,
  PaymentMethodChangeEvent = 9009,
  PaymentRequest = 9034,
  PaymentRequestUpdateEvent = 9049,
  PaymentResponse = 9075,
  Performance = 9091,
  PerformanceEntry = 9103,
  PerformanceEntryEvent = 9120,
  PerformanceEventTiming = 9142,
  PerformanceMark = 9165,
  PerformanceMeasure = 9181,
  PerformanceNavigation = 9200,
  PerformanceNavigationTiming = 9222,
  PerformanceObserver = 9250,
  PerformanceObserverEntryList = 9270,
  PerformancePaintTiming = 9299,
  PerformanceResourceTiming = 9322,
  PerformanceServerTiming = 9348,
  PerformanceTiming = 9372,
  PeriodicWave = 9390,
  PermissionStatus = 9403,
  Permissions = 9420,
  PlacesBookmark = 9432,
  PlacesBookmarkAddition = 9447,
  PlacesBookmarkChanged = 9470,
  PlacesBookmarkGuid = 9492,
  PlacesBookmarkKeyword = 9511,
  PlacesBookmarkMoved = 9533,
  PlacesBookmarkRemoved = 9553,
  PlacesBookmarkTags = 9575,
  PlacesBookmarkTime = 9594,
  PlacesBookmarkTitle = 9613,
  PlacesBookmarkUrl = 9633,
  PlacesEvent = 9651,
  PlacesFavicon = 9663,
  PlacesHistoryCleared = 9677,
  PlacesObservers = 9698,
  PlacesPurgeCaches = 9714,
  PlacesRanking = 9732,
  PlacesVisit = 9746,
  PlacesVisitRemoved = 9758,
  PlacesVisitTitle = 9777,
  PlacesWeakCallbackWrapper = 9794,
  Plugin = 9820,
  PluginArray = 9827,
  PluginCrashedEvent = 9839,
  PointerEvent = 9858,
  PopStateEvent = 9871,
  PopupBlockedEvent = 9885,
  PopupPositionedEvent = 9903,
  PositionStateEvent = 9924,
  PrecompiledScript = 9943,
  ProcessMessageManager = 9961,
  ProcessingInstruction = 9983,
  ProgressEvent = 10005,
  PromiseDebugging = 10019,
  PromiseNativeHandler = 10036,
  PromiseRejectionEvent = 10057,
  PublicKeyCredential = 10079,
  PushEvent = 10099,
  PushManager = 10109,
  PushManagerImpl = 10121,
  PushMessageData = 10137,
  PushSubscription = 10153,
  PushSubscriptionOptions = 10170,
  RadioNodeList = 10194,
  Range = 10208,
  ReadableByteStreamController = 10214,
  ReadableStream = 10243,
  ReadableStream_AsyncIterator = 10258,
  ReadableStreamBYOBReader = 10287,
  ReadableStreamBYOBRequest = 10312,
  ReadableStreamDefaultController = 10338,
  ReadableStreamDefaultReader = 10370,
  Report = 10398,
  ReportBody = 10405,
  ReportingObserver = 10416,
  Request = 10434,
  ResizeObserver = 10442,
  ResizeObserverEntry = 10457,
  ResizeObserverSize = 10477,
  Response = 10496,
  SVGAElement = 10505,
  SVGAngle = 10517,
  SVGAnimateElement = 10526,
  SVGAnimateMotionElement = 10544,
  SVGAnimateTransformElement = 10568,
  SVGAnimatedAngle = 10595,
  SVGAnimatedBoolean = 10612,
  SVGAnimatedEnumeration = 10631,
  SVGAnimatedInteger = 10654,
  SVGAnimatedLength = 10673,
  SVGAnimatedLengthList = 10691,
  SVGAnimatedNumber = 10713,
  SVGAnimatedNumberList = 10731,
  SVGAnimatedPreserveAspectRatio = 10753,
  SVGAnimatedRect = 10784,
  SVGAnimatedString = 10800,
  SVGAnimatedTransformList = 10818,
  SVGAnimationElement = 10843,
  SVGCircleElement = 10863,
  SVGClipPathElement = 10880,
  SVGComponentTransferFunctionElement = 10899,
  SVGDefsElement = 10935,
  SVGDescElement = 10950,
  SVGElement = 10965,
  SVGEllipseElement = 10976,
  SVGFEBlendElement = 10994,
  SVGFEColorMatrixElement = 11012,
  SVGFEComponentTransferElement = 11036,
  SVGFECompositeElement = 11066,
  SVGFEConvolveMatrixElement = 11088,
  SVGFEDiffuseLightingElement = 11115,
  SVGFEDisplacementMapElement = 11143,
  SVGFEDistantLightElement = 11171,
  SVGFEDropShadowElement = 11196,
  SVGFEFloodElement = 11219,
  SVGFEFuncAElement = 11237,
  SVGFEFuncBElement = 11255,
  SVGFEFuncGElement = 11273,
  SVGFEFuncRElement = 11291,
  SVGFEGaussianBlurElement = 11309,
  SVGFEImageElement = 11334,
  SVGFEMergeElement = 11352,
  SVGFEMergeNodeElement = 11370,
  SVGFEMorphologyElement = 11392,
  SVGFEOffsetElement = 11415,
  SVGFEPointLightElement = 11434,
  SVGFESpecularLightingElement = 11457,
  SVGFESpotLightElement = 11486,
  SVGFETileElement = 11508,
  SVGFETurbulenceElement = 11525,
  SVGFilterElement = 11548,
  SVGForeignObjectElement = 11565,
  SVGGElement = 11589,
  SVGGeometryElement = 11601,
  SVGGradientElement = 11620,
  SVGGraphicsElement = 11639,
  SVGImageElement = 11658,
  SVGLength = 11674,
  SVGLengthList = 11684,
  SVGLineElement = 11698,
  SVGLinearGradientElement = 11713,
  SVGMPathElement = 11738,
  SVGMarkerElement = 11754,
  SVGMaskElement = 11771,
  SVGMatrix = 11786,
  SVGMetadataElement = 11796,
  SVGNumber = 11815,
  SVGNumberList = 11825,
  SVGPathElement = 11839,
  SVGPathSeg = 11854,
  SVGPathSegArcAbs = 11865,
  SVGPathSegArcRel = 11882,
  SVGPathSegClosePath = 11899,
  SVGPathSegCurvetoCubicAbs = 11919,
  SVGPathSegCurvetoCubicRel = 11945,
  SVGPathSegCurvetoCubicSmoothAbs = 11971,
  SVGPathSegCurvetoCubicSmoothRel = 12003,
  SVGPathSegCurvetoQuadraticAbs = 12035,
  SVGPathSegCurvetoQuadraticRel = 12065,
  SVGPathSegCurvetoQuadraticSmoothAbs = 12095,
  SVGPathSegCurvetoQuadraticSmoothRel = 12131,
  SVGPathSegLinetoAbs = 12167,
  SVGPathSegLinetoHorizontalAbs = 12187,
  SVGPathSegLinetoHorizontalRel = 12217,
  SVGPathSegLinetoRel = 12247,
  SVGPathSegLinetoVerticalAbs = 12267,
  SVGPathSegLinetoVerticalRel = 12295,
  SVGPathSegList = 12323,
  SVGPathSegMovetoAbs = 12338,
  SVGPathSegMovetoRel = 12358,
  SVGPatternElement = 12378,
  SVGPoint = 12396,
  SVGPointList = 12405,
  SVGPolygonElement = 12418,
  SVGPolylineElement = 12436,
  SVGPreserveAspectRatio = 12455,
  SVGRadialGradientElement = 12478,
  SVGRect = 12503,
  SVGRectElement = 12511,
  SVGSVGElement = 12526,
  SVGScriptElement = 12540,
  SVGSetElement = 12557,
  SVGStopElement = 12571,
  SVGStringList = 12586,
  SVGStyleElement = 12600,
  SVGSwitchElement = 12616,
  SVGSymbolElement = 12633,
  SVGTSpanElement = 12650,
  SVGTextContentElement = 12666,
  SVGTextElement = 12688,
  SVGTextPathElement = 12703,
  SVGTextPositioningElement = 12722,
  SVGTitleElement = 12748,
  SVGTransform = 12764,
  SVGTransformList = 12777,
  SVGUnitTypes = 12794,
  SVGUseElement = 12807,
  SVGViewElement = 12821,
  Sanitizer = 12836,
  Scheduler = 12846,
  Screen = 12856,
  ScreenLuminance = 12863,
  ScreenOrientation = 12879,
  ScriptProcessorNode = 12897,
  ScrollAreaEvent = 12917,
  ScrollViewChangeEvent = 12933,
  SecurityPolicyViolationEvent = 12955,
  Selection = 12984,
  ServiceWorker = 12994,
  ServiceWorkerContainer = 13008,
  ServiceWorkerGlobalScope = 13031,
  ServiceWorkerRegistration = 13056,
  SessionStoreFormData = 13082,
  SessionStoreScrollData = 13103,
  SessionStoreUtils = 13126,
  ShadowRealmGlobalScope = 13144,
  ShadowRoot = 13167,
  SharedWorker = 13178,
  SharedWorkerGlobalScope = 13191,
  SimpleGestureEvent = 13215,
  SourceBuffer = 13234,
  SourceBufferList = 13247,
  SpeechGrammar = 13264,
  SpeechGrammarList = 13278,
  SpeechRecognition = 13296,
  SpeechRecognitionAlternative = 13314,
  SpeechRecognitionError = 13343,
  SpeechRecognitionEvent = 13366,
  SpeechRecognitionResult = 13389,
  SpeechRecognitionResultList = 13413,
  SpeechSynthesis = 13441,
  SpeechSynthesisErrorEvent = 13457,
  SpeechSynthesisEvent = 13483,
  SpeechSynthesisUtterance = 13504,
  SpeechSynthesisVoice = 13529,
  StaticRange = 13550,
  StereoPannerNode = 13562,
  Storage = 13579,
  StorageEvent = 13587,
  StorageManager = 13600,
  StreamFilter = 13615,
  StreamFilterDataEvent = 13628,
  StructuredCloneHolder = 13650,
  StructuredCloneTester = 13672,
  StyleSheet = 13694,
  StyleSheetApplicableStateChangeEvent = 13705,
  StyleSheetList = 13742,
  SubmitEvent = 13757,
  SubtleCrypto = 13769,
  SyncMessageSender = 13782,
  SyncReadFile = 13800,
  TCPServerSocket = 13813,
  TCPServerSocketEvent = 13829,
  TCPSocket = 13850,
  TCPSocketErrorEvent = 13860,
  TCPSocketEvent = 13880,
  TaskController = 13895,
  TaskPriorityChangeEvent = 13910,
  TaskSignal = 13934,
  TelemetryStopwatch = 13945,
  TestUtils = 13964,
  TestingDeprecatedInterface = 13974,
  Text = 14001,
  TextClause = 14006,
  TextDecoder = 14017,
  TextDecoderStream = 14029,
  TextEncoder = 14047,
  TextEncoderStream = 14059,
  TextMetrics = 14077,
  TextTrack = 14089,
  TextTrackCue = 14099,
  TextTrackCueList = 14112,
  TextTrackList = 14129,
  TimeEvent = 14143,
  TimeRanges = 14153,
  ToggleEvent = 14164,
  Touch = 14176,
  TouchEvent = 14182,
  TouchList = 14193,
  TrackEvent = 14203,
  TransformStream = 14214,
  TransformStreamDefaultController = 14230,
  TransitionEvent = 14263,
  TreeColumn = 14279,
  TreeColumns = 14290,
  TreeContentView = 14302,
  TreeWalker = 14318,
  UDPMessageEvent = 14329,
  UDPSocket = 14345,
  UIEvent = 14355,
  URL = 14363,
  URLSearchParams = 14367,
  URLSearchParams_Iterator = 14383,
  UniFFIPointer = 14408,
  UniFFIScaffolding = 14422,
  UserInteraction = 14440,
  UserProximityEvent = 14456,
  VRDisplay = 14475,
  VRDisplayCapabilities = 14485,
  VRDisplayEvent = 14507,
  VREyeParameters = 14522,
  VRFieldOfView = 14538,
  VRFrameData = 14552,
  VRMockController = 14564,
  VRMockDisplay = 14581,
  VRPose = 14595,
  VRServiceTest = 14602,
  VRStageParameters = 14616,
  VTTCue = 14634,
  VTTRegion = 14641,
  ValidityState = 14651,
  VideoColorSpace = 14665,
  VideoFrame = 14681,
  VideoPlaybackQuality = 14692,
  VideoTrack = 14713,
  VideoTrackList = 14724,
  VisualViewport = 14739,
  WEBGL_color_buffer_float = 14754,
  WEBGL_compressed_texture_astc = 14779,
  WEBGL_compressed_texture_etc = 14809,
  WEBGL_compressed_texture_etc1 = 14838,
  WEBGL_compressed_texture_pvrtc = 14868,
  WEBGL_compressed_texture_s3tc = 14899,
  WEBGL_compressed_texture_s3tc_srgb = 14929,
  WEBGL_debug_renderer_info = 14964,
  WEBGL_debug_shaders = 14990,
  WEBGL_depth_texture = 15010,
  WEBGL_draw_buffers = 15030,
  WEBGL_explicit_present = 15049,
  WEBGL_lose_context = 15072,
  WEBGL_provoking_vertex = 15091,
  WaveShaperNode = 15114,
  WebExtensionContentScript = 15129,
  WebExtensionPolicy = 15155,
  WebGL2RenderingContext = 15174,
  WebGLActiveInfo = 15197,
  WebGLBuffer = 15213,
  WebGLContextEvent = 15225,
  WebGLFramebuffer = 15243,
  WebGLProgram = 15260,
  WebGLQuery = 15273,
  WebGLRenderbuffer = 15284,
  WebGLRenderingContext = 15302,
  WebGLSampler = 15324,
  WebGLShader = 15337,
  WebGLShaderPrecisionFormat = 15349,
  WebGLSync = 15376,
  WebGLTexture = 15386,
  WebGLTransformFeedback = 15399,
  WebGLUniformLocation = 15422,
  WebGLVertexArrayObject = 15443,
  WebKitCSSMatrix = 15466,
  WebSocket = 15482,
  WebTransport = 15492,
  WebTransportBidirectionalStream = 15505,
  WebTransportDatagramDuplexStream = 15537,
  WebTransportError = 15570,
  WebTransportReceiveStream = 15588,
  WebTransportSendStream = 15614,
  WheelEvent = 15637,
  Window = 15648,
  WindowClient = 15655,
  WindowContext = 15668,
  WindowGlobalChild = 15682,
  WindowGlobalParent = 15700,
  WindowRoot = 15719,
  Worker = 15730,
  WorkerDebuggerGlobalScope = 15737,
  WorkerGlobalScope = 15763,
  WorkerLocation = 15781,
  WorkerNavigator = 15796,
  WorkerTestUtils = 15812,
  Worklet = 15828,
  WorkletGlobalScope = 15836,
  WritableStream = 15855,
  WritableStreamDefaultController = 15870,
  WritableStreamDefaultWriter = 15902,
  XMLDocument = 15930,
  XMLHttpRequest = 15942,
  XMLHttpRequestEventTarget = 15957,
  XMLHttpRequestUpload = 15983,
  XMLSerializer = 16004,
  XPathEvaluator = 16018,
  XPathExpression = 16033,
  XPathResult = 16049,
  XRBoundedReferenceSpace = 16061,
  XRFrame = 16085,
  XRInputSource = 16093,
  XRInputSourceArray = 16107,
  XRInputSourceEvent = 16126,
  XRInputSourcesChangeEvent = 16145,
  XRPose = 16171,
  XRReferenceSpace = 16178,
  XRReferenceSpaceEvent = 16195,
  XRRenderState = 16217,
  XRRigidTransform = 16231,
  XRSession = 16248,
  XRSessionEvent = 16258,
  XRSpace = 16273,
  XRSystem = 16281,
  XRView = 16290,
  XRViewerPose = 16297,
  XRViewport = 16310,
  XRWebGLLayer = 16321,
  XSLTProcessor = 16334,
  XULCommandEvent = 16348,
  XULElement = 16364,
  XULFrameElement = 16375,
  XULMenuElement = 16391,
  XULPopupElement = 16406,
  XULResizerElement = 16422,
  XULTextElement = 16440,
  XULTreeElement = 16455,
  console = 16470,
  webkitSpeechGrammar = 16478,
  webkitSpeechGrammarList = 16498,
  webkitSpeechRecognition = 16522,
  webkitURL = 16546,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // mozilla_dom_BindingNames_h
