/* THIS FILE IS AUTOGENERATED FROM IOUtils.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_IOUTILSBINDING_H_
#define DOM_IOUTILSBINDING_H_

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "js/Value.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"
#include "mozilla/dom/UnionMember.h"

namespace mozilla {

class IOUtils;
class SyncReadFile;

namespace dom {

struct CopyOptionsAtoms;
struct FdMapping;
struct FdMappingAtoms;
struct FileInfoAtoms;
struct GetChildrenOptionsAtoms;
struct HasChildrenOptionsAtoms;
struct LaunchOptionsAtoms;
struct MakeDirectoryOptionsAtoms;
struct MoveOptionsAtoms;
struct NativePropertyHooks;
class OwningUTF8StringOrUint8Array;
class ProtoAndIfaceCache;
struct ReadOptionsAtoms;
struct ReadUTF8OptionsAtoms;
struct RemoveOptionsAtoms;
class UTF8StringOrUint8Array;
struct WriteOptionsAtoms;

} // namespace dom

} // namespace mozilla

namespace mozilla {

namespace dom {

enum class WriteMode : uint8_t {
  Overwrite,
  Append,
  AppendOrCreate,
  Create,
};

namespace binding_detail {
template <> struct EnumStrings<WriteMode> {
  static constexpr nsLiteralCString Values[4] {
    "overwrite"_ns,
    "append"_ns,
    "appendOrCreate"_ns,
    "create"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, WriteMode aArgument, JS::MutableHandle<JS::Value> aValue);


enum class FileType : uint8_t {
  Regular,
  Directory,
  Other,
};

namespace binding_detail {
template <> struct EnumStrings<FileType> {
  static constexpr nsLiteralCString Values[3] {
    "regular"_ns,
    "directory"_ns,
    "other"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, FileType aArgument, JS::MutableHandle<JS::Value> aValue);


enum class HashAlgorithm : uint8_t {
  Sha256,
  Sha384,
  Sha512,
};

namespace binding_detail {
template <> struct EnumStrings<HashAlgorithm> {
  static constexpr nsLiteralCString Values[3] {
    "sha256"_ns,
    "sha384"_ns,
    "sha512"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, HashAlgorithm aArgument, JS::MutableHandle<JS::Value> aValue);


struct CopyOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mNoOverwrite;
  MOZ_INIT_OUTSIDE_CTOR bool mRecursive;

  CopyOptions();

  explicit inline CopyOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CopyOptions(CopyOptions&& aOther) = default;

  explicit inline CopyOptions(const CopyOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  CopyOptions&
  operator=(const CopyOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, CopyOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastCopyOptions : public CopyOptions
{
  inline FastCopyOptions()
    : CopyOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct FdMapping : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mDst;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mSrc;

  FdMapping();

  explicit inline FdMapping(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FdMapping(FdMapping&& aOther) = default;

  explicit inline FdMapping(const FdMapping& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  FdMapping&
  operator=(const FdMapping& aOther);

private:
  static bool
  InitIds(JSContext* cx, FdMappingAtoms* atomsCache);
};

namespace binding_detail {
struct FastFdMapping : public FdMapping
{
  inline FastFdMapping()
    : FdMapping(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct FileInfo : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mCreationTime;
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mLastAccessed;
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mLastModified;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mPath;
  MOZ_INIT_OUTSIDE_CTOR Optional<uint32_t> mPermissions;
  MOZ_INIT_OUTSIDE_CTOR Optional<int64_t> mSize;
  MOZ_INIT_OUTSIDE_CTOR Optional<FileType> mType;

  FileInfo();

  explicit inline FileInfo(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  FileInfo(FileInfo&& aOther) = default;

  explicit inline FileInfo(const FileInfo& aOther)
  {
    *this = aOther;
  }

  bool
  Init(const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  FileInfo&
  operator=(const FileInfo& aOther);

private:
  static bool
  InitIds(JSContext* cx, FileInfoAtoms* atomsCache);
};

namespace binding_detail {
struct FastFileInfo : public FileInfo
{
  inline FastFileInfo()
    : FileInfo(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct GetChildrenOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreAbsent;

  GetChildrenOptions();

  explicit inline GetChildrenOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  GetChildrenOptions(GetChildrenOptions&& aOther) = default;

  explicit inline GetChildrenOptions(const GetChildrenOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  GetChildrenOptions&
  operator=(const GetChildrenOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, GetChildrenOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastGetChildrenOptions : public GetChildrenOptions
{
  inline FastGetChildrenOptions()
    : GetChildrenOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct HasChildrenOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreAbsent;

  HasChildrenOptions();

  explicit inline HasChildrenOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  HasChildrenOptions(HasChildrenOptions&& aOther) = default;

  explicit inline HasChildrenOptions(const HasChildrenOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  HasChildrenOptions&
  operator=(const HasChildrenOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, HasChildrenOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastHasChildrenOptions : public HasChildrenOptions
{
  inline FastHasChildrenOptions()
    : HasChildrenOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MakeDirectoryOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mCreateAncestors;
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreExisting;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mPermissions;

  MakeDirectoryOptions();

  explicit inline MakeDirectoryOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MakeDirectoryOptions(MakeDirectoryOptions&& aOther) = default;

  explicit inline MakeDirectoryOptions(const MakeDirectoryOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MakeDirectoryOptions&
  operator=(const MakeDirectoryOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, MakeDirectoryOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastMakeDirectoryOptions : public MakeDirectoryOptions
{
  inline FastMakeDirectoryOptions()
    : MakeDirectoryOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct MoveOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mNoOverwrite;

  MoveOptions();

  explicit inline MoveOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MoveOptions(MoveOptions&& aOther) = default;

  explicit inline MoveOptions(const MoveOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  MoveOptions&
  operator=(const MoveOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, MoveOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastMoveOptions : public MoveOptions
{
  inline FastMoveOptions()
    : MoveOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ReadUTF8Options : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mDecompress;

  ReadUTF8Options();

  explicit inline ReadUTF8Options(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ReadUTF8Options(ReadUTF8Options&& aOther) = default;

  explicit inline ReadUTF8Options(const ReadUTF8Options& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ReadUTF8Options&
  operator=(const ReadUTF8Options& aOther);

private:
  static bool
  InitIds(JSContext* cx, ReadUTF8OptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastReadUTF8Options : public ReadUTF8Options
{
  inline FastReadUTF8Options()
    : ReadUTF8Options(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct RemoveOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mIgnoreAbsent;
  MOZ_INIT_OUTSIDE_CTOR bool mRecursive;
  MOZ_INIT_OUTSIDE_CTOR bool mRetryReadonly;

  RemoveOptions();

  explicit inline RemoveOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  RemoveOptions(RemoveOptions&& aOther) = default;

  explicit inline RemoveOptions(const RemoveOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  RemoveOptions&
  operator=(const RemoveOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, RemoveOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastRemoveOptions : public RemoveOptions
{
  inline FastRemoveOptions()
    : RemoveOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class UTF8StringOrUint8Array : public AllUnionBase,
                               public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<UTF8StringOrUint8Array, true, Uint8Array>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUint8Array
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUint8Array = TypeOrUninit::eUint8Array
  };

private:
  union Value
  {
    UnionMember<binding_detail::FakeString<char> > mUTF8String;
    UnionMember<RootedSpiderMonkeyInterface<Uint8Array> > mUint8Array;

  };

  TypeOrUninit mType;
  Value mValue;

  UTF8StringOrUint8Array(const UTF8StringOrUint8Array&) = delete;
  UTF8StringOrUint8Array& operator=(const UTF8StringOrUint8Array&) = delete;
public:
  explicit inline UTF8StringOrUint8Array()
    : mType(eUninitialized)
  {
  }

  inline ~UTF8StringOrUint8Array()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  RawSetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char>&
  SetAsUTF8String()
  {
    if (mType == eUTF8String) {
      return mValue.mUTF8String.Value();
    }
    Uninit();
    mType = eUTF8String;
    return mValue.mUTF8String.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline binding_detail::FakeString<char>&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline const nsACString&
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<Uint8Array>&
  RawSetAsUint8Array(JSContext* cx)
  {
    if (mType == eUint8Array) {
      return mValue.mUint8Array.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eUint8Array;
    return mValue.mUint8Array.SetValue(cx);
  }

  [[nodiscard]] inline RootedSpiderMonkeyInterface<Uint8Array>&
  SetAsUint8Array(JSContext* cx)
  {
    if (mType == eUint8Array) {
      return mValue.mUint8Array.Value();
    }
    Uninit();
    mType = eUint8Array;
    return mValue.mUint8Array.SetValue(cx);
  }

  inline bool
  IsUint8Array() const
  {
    return mType == eUint8Array;
  }

  inline RootedSpiderMonkeyInterface<Uint8Array>&
  GetAsUint8Array()
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    return mValue.mUint8Array.Value();
  }

  inline Uint8Array const &
  GetAsUint8Array() const
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    return mValue.mUint8Array.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eUTF8String: {
        DestroyUTF8String();
        break;
      }
      case eUint8Array: {
        DestroyUint8Array();
        break;
      }
    }
  }

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    mValue.mUTF8String.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToUint8Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUint8Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyUint8Array()
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    mValue.mUint8Array.Destroy();
    mType = eUninitialized;
  }
};


class OwningUTF8StringOrUint8Array : public AllOwningUnionBase,
                                     public UnionWithTypedArraysBase
{
public:
  using ApplyToTypedArrays = binding_detail::ApplyToTypedArraysHelper<OwningUTF8StringOrUint8Array, true, Uint8Array>;

private:
  enum TypeOrUninit
  {
    eUninitialized,
    eUTF8String,
    eUint8Array
  };
public:
  enum class Type
  {
    eUTF8String = TypeOrUninit::eUTF8String,
    eUint8Array = TypeOrUninit::eUint8Array
  };

private:
  union Value
  {
    UnionMember<nsCString > mUTF8String;
    UnionMember<Uint8Array > mUint8Array;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningUTF8StringOrUint8Array(const OwningUTF8StringOrUint8Array&) = delete;
  OwningUTF8StringOrUint8Array& operator=(const OwningUTF8StringOrUint8Array&) = delete;
public:
  explicit inline OwningUTF8StringOrUint8Array()
    : mType(eUninitialized)
  {
  }

  OwningUTF8StringOrUint8Array(OwningUTF8StringOrUint8Array&& aOther);

  inline ~OwningUTF8StringOrUint8Array()
  {
    Uninit();
  }

  [[nodiscard]] nsCString&
  RawSetAsUTF8String();

  [[nodiscard]] nsCString&
  SetAsUTF8String();

  template <int N>
  inline void
  SetStringLiteral(const nsCString::char_type (&aData)[N])
  {
    RawSetAsUTF8String().AssignLiteral(aData);
  }

  inline bool
  IsUTF8String() const
  {
    return mType == eUTF8String;
  }

  inline nsCString&
  GetAsUTF8String()
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  inline nsCString const &
  GetAsUTF8String() const
  {
    MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
    return mValue.mUTF8String.Value();
  }

  [[nodiscard]] Uint8Array&
  RawSetAsUint8Array();

  [[nodiscard]] Uint8Array&
  SetAsUint8Array();

  inline bool
  IsUint8Array() const
  {
    return mType == eUint8Array;
  }

  inline Uint8Array&
  GetAsUint8Array()
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    return mValue.mUint8Array.Value();
  }

  inline Uint8Array const &
  GetAsUint8Array() const
  {
    MOZ_RELEASE_ASSERT(IsUint8Array(), "Wrong type!");
    return mValue.mUint8Array.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  bool
  ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceUnion(JSTracer* trc);

  OwningUTF8StringOrUint8Array&
  operator=(OwningUTF8StringOrUint8Array&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUTF8String();

  bool
  TrySetToUint8Array(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToUint8Array(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyUint8Array();
};


struct WriteOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mBackupFile;
  MOZ_INIT_OUTSIDE_CTOR bool mCompress;
  MOZ_INIT_OUTSIDE_CTOR bool mFlush;
  MOZ_INIT_OUTSIDE_CTOR WriteMode mMode;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mTmpPath;

  WriteOptions();

  explicit inline WriteOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WriteOptions(WriteOptions&& aOther) = default;

  explicit inline WriteOptions(const WriteOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  WriteOptions&
  operator=(const WriteOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, WriteOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastWriteOptions : public WriteOptions
{
  inline FastWriteOptions()
    : WriteOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct LaunchOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mDisclaim;
  MOZ_INIT_OUTSIDE_CTOR Sequence<OwningUTF8StringOrUint8Array> mEnvironment;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<FdMapping>> mFdMap;
  MOZ_INIT_OUTSIDE_CTOR Optional<OwningUTF8StringOrUint8Array> mWorkdir;

  LaunchOptions();

  explicit inline LaunchOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  LaunchOptions(LaunchOptions&& aOther) = default;

private:
  LaunchOptions(const LaunchOptions&) = delete;
  LaunchOptions& operator=(const LaunchOptions&) = delete;

  static bool
  InitIds(JSContext* cx, LaunchOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastLaunchOptions : public LaunchOptions
{
  inline FastLaunchOptions()
    : LaunchOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ReadOptions : public ReadUTF8Options
{
  MOZ_INIT_OUTSIDE_CTOR Nullable<uint32_t> mMaxBytes;
  MOZ_INIT_OUTSIDE_CTOR uint64_t mOffset;

  ReadOptions();

  explicit inline ReadOptions(const FastDictionaryInitializer& )
    : ReadUTF8Options(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ReadOptions(ReadOptions&& aOther) = default;

  explicit inline ReadOptions(const ReadOptions& aOther)
    : ReadUTF8Options(FastDictionaryInitializer())
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ReadOptions&
  operator=(const ReadOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ReadOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastReadOptions : public ReadOptions
{
  inline FastReadOptions()
    : ReadOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace IOUtils_Binding {

  typedef mozilla::IOUtils NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::IOUtils,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace IOUtils_Binding



namespace SyncReadFile_Binding {

  typedef mozilla::SyncReadFile NativeType;

  bool
  ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj);

  bool
  Wrap(JSContext* aCx, mozilla::SyncReadFile* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::SyncReadFile,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace SyncReadFile_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::WriteMode>
{
  static constexpr dom::WriteMode value = dom::WriteMode::Create;

  static_assert(static_cast<uint8_t>(dom::WriteMode::Overwrite) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::WriteMode>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::FileType>
{
  static constexpr dom::FileType value = dom::FileType::Other;

  static_assert(static_cast<uint8_t>(dom::FileType::Regular) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::FileType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::HashAlgorithm>
{
  static constexpr dom::HashAlgorithm value = dom::HashAlgorithm::Sha512;

  static_assert(static_cast<uint8_t>(dom::HashAlgorithm::Sha256) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::HashAlgorithm>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_IOUTILSBINDING_H_
