/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextSysBuiltins {
    private static Object selectOut(int fd) {
        CompilerAsserts.neverPartOfCompilation();
        PythonModule sys = PythonContext.get(null).lookupBuiltinModule(BuiltinNames.T_SYS);
        Object file = fd == 0 ? sys.getAttribute(BuiltinNames.T_STDOUT) : sys.getAttribute(BuiltinNames.T_STDERR);
        return file;
    }

    static abstract class GraalPyPrivate_Sys_FormatStd
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        GraalPyPrivate_Sys_FormatStd() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(int fd, TruffleString format, Object vaList) {
            try {
                Object msg = CExtNodes.UnicodeFromFormatNode.executeUncached(format, vaList);
                PyObjectCallMethodObjArgs.executeUncached(PythonCextSysBuiltins.selectOut(fd), IONodes.T_WRITE, msg);
                return 0;
            }
            catch (PException e) {
                return -1;
            }
        }
    }

    static abstract class GraalPyPrivate_Sys_WriteStd
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Sys_WriteStd() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doGeneric(int fd, TruffleString msg) {
            try {
                PyObjectCallMethodObjArgs.executeUncached(PythonCextSysBuiltins.selectOut(fd), IONodes.T_WRITE, msg);
                return 0;
            }
            catch (PException e) {
                return -1;
            }
        }
    }

    static abstract class PySys_GetObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PySys_GetObject() {
        }

        @Specialization
        Object getObject(TruffleString name, @Bind Node inliningTarget, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteNode, @Cached PyObjectLookupAttr lookupNode, @Cached PyObjectSetAttr setAttrNode) {
            try {
                PythonModule sys = this.getCore().lookupBuiltinModule(BuiltinNames.T_SYS);
                Object value = lookupNode.execute(null, inliningTarget, sys, name);
                if (value == PNone.NO_VALUE) {
                    return this.getNativeNull();
                }
                Object promotedValue = promoteNode.execute(inliningTarget, value);
                if (promotedValue != null) {
                    setAttrNode.execute(inliningTarget, sys, name, promotedValue);
                    return promotedValue;
                }
                return value;
            }
            catch (PException e) {
                return this.getNativeNull();
            }
        }
    }
}

