/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.nativeimage.hosted;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;

@Platforms(value={Platform.HOSTED_ONLY.class})
public final class RuntimeReflection {
    public static void register(Class<?> ... classes) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).register(ConfigurationCondition.alwaysTrue(), classes);
    }

    public static void registerClassLookup(String className) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerClassLookup(ConfigurationCondition.alwaysTrue(), className);
    }

    public static void register(Executable ... methods) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).register(ConfigurationCondition.alwaysTrue(), false, methods);
    }

    public static void registerAsQueried(Executable ... methods) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).register(ConfigurationCondition.alwaysTrue(), true, methods);
    }

    public static void registerMethodLookup(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerMethodLookup(ConfigurationCondition.alwaysTrue(), declaringClass, methodName, parameterTypes);
    }

    public static void registerConstructorLookup(Class<?> declaringClass, Class<?> ... parameterTypes) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerConstructorLookup(ConfigurationCondition.alwaysTrue(), declaringClass, parameterTypes);
    }

    public static void register(Field ... fields) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).register(ConfigurationCondition.alwaysTrue(), false, fields);
    }

    public static void registerFieldLookup(Class<?> declaringClass, String fieldName) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerFieldLookup(ConfigurationCondition.alwaysTrue(), declaringClass, fieldName);
    }

    public static void registerAllClasses(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllClassesQuery(ConfigurationCondition.alwaysTrue(), declaringClass);
    }

    public static void registerAllDeclaredClasses(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllDeclaredClassesQuery(ConfigurationCondition.alwaysTrue(), declaringClass);
    }

    public static void registerAllMethods(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllMethodsQuery(ConfigurationCondition.alwaysTrue(), true, declaringClass);
    }

    public static void registerAllDeclaredMethods(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllDeclaredMethodsQuery(ConfigurationCondition.alwaysTrue(), true, declaringClass);
    }

    public static void registerAllConstructors(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllConstructorsQuery(ConfigurationCondition.alwaysTrue(), true, declaringClass);
    }

    public static void registerAllDeclaredConstructors(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllDeclaredConstructorsQuery(ConfigurationCondition.alwaysTrue(), true, declaringClass);
    }

    public static void registerAllFields(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllFields(ConfigurationCondition.alwaysTrue(), declaringClass);
    }

    public static void registerAllDeclaredFields(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllDeclaredFields(ConfigurationCondition.alwaysTrue(), declaringClass);
    }

    public static void registerAllNestMembers(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllNestMembersQuery(ConfigurationCondition.alwaysTrue(), declaringClass);
    }

    public static void registerAllPermittedSubclasses(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllPermittedSubclassesQuery(ConfigurationCondition.alwaysTrue(), declaringClass);
    }

    public static void registerAllRecordComponents(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllRecordComponentsQuery(ConfigurationCondition.alwaysTrue(), declaringClass);
    }

    public static void registerAllSigners(Class<?> declaringClass) {
        ImageSingletons.lookup(RuntimeReflectionSupport.class).registerAllSignersQuery(ConfigurationCondition.alwaysTrue(), declaringClass);
    }

    @Deprecated(since="21.1")
    public static void register(boolean finalIsWritable, Field ... fields) {
        RuntimeReflection.register(fields);
    }

    @Deprecated(since="21.1")
    public static void register(boolean finalIsWritable, boolean allowUnsafeAccess, Field ... fields) {
        RuntimeReflection.register(fields);
    }

    public static void registerForReflectiveInstantiation(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            Constructor<?> nullaryConstructor;
            if (clazz.isArray() || clazz.isInterface() || Modifier.isAbstract(clazz.getModifiers())) {
                throw new IllegalArgumentException("Class " + clazz.getTypeName() + " cannot be instantiated reflectively. It must be a non-abstract instance type.");
            }
            try {
                nullaryConstructor = clazz.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalArgumentException("Class " + clazz.getTypeName() + " cannot be instantiated reflectively . It does not have a nullary constructor.");
            }
            RuntimeReflection.register(nullaryConstructor);
        }
    }

    private RuntimeReflection() {
    }
}

