/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Executable;
import java.net.Authenticator;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class ProxyHelper {
    private static final Pattern HTTP_PROXY_STATUS_LINE_PATTERN;
    private static final int SOCKS_COMMAND_CONNECT = 1;
    private static final int SOCKS_VERSION4 = 4;
    private static final int SOCKS_VERSION5 = 5;
    private static final int SOCKS_RESPONSE_REQUEST_OK = 0;
    private static final int SOCKS_AUTH_TYPE_NO_AUTHENTICATION = 0;
    private static final int SOCKS_AUTH_TYPE_USER_PASSWORD = 2;
    private static final int SOCKS_AUTH_TYPE_UNKNOWN = -1;
    private static final int SOCKS_ADDRESS_TYPE_IPV4 = 1;
    private static final int SOCKS_ADDRESS_TYPE_DOMAIN_NAME = 3;
    private static final int SOCKS_ADDRESS_TYPE_IPV6 = 4;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;

    ProxyHelper() {
    }

    static void connectViaProxy(Proxy proxy, InetSocketAddress endPoint, SocketChannel socketChannel) throws IOException {
        if (proxy.type() == Proxy.Type.HTTP) {
            ProxyHelper.doHTTPTunneling(endPoint, socketChannel);
        } else if (proxy.type() == Proxy.Type.SOCKS) {
            ProxyHelper.doSOCKSTunneling(endPoint, socketChannel, proxy);
        } else {
            throw new IOException("Unknown proxy type : " + proxy.type());
        }
    }

    private static void doHTTPTunneling(InetSocketAddress endPoint, SocketChannel socketChannel) throws IOException {
        String remoteHost = endPoint.getHostString() + ":" + endPoint.getPort();
        StringBuilder httpTunnelRequest = new StringBuilder();
        httpTunnelRequest.append("CONNECT " + remoteHost + " HTTP/1.0\r\n");
        httpTunnelRequest.append("Host: " + remoteHost + "\r\n");
        httpTunnelRequest.append("\r\n");
        ByteBuffer requestBuffer = ByteBuffer.wrap(httpTunnelRequest.toString().getBytes(StandardCharsets.ISO_8859_1));
        while (requestBuffer.hasRemaining()) {
            socketChannel.write(requestBuffer);
        }
        ByteBuffer responseBuffer = ByteBuffer.allocate(512);
        socketChannel.read(responseBuffer);
        responseBuffer.flip();
        String response = new String(responseBuffer.array(), responseBuffer.arrayOffset(), responseBuffer.limit(), StandardCharsets.US_ASCII);
        BufferedReader responseReader = new BufferedReader(new StringReader(response));
        String statusLine = responseReader.readLine();
        Matcher matcher = HTTP_PROXY_STATUS_LINE_PATTERN.matcher(statusLine);
        if (!matcher.matches()) {
            throw new IOException("HTTP proxy tunneling failed [" + statusLine + "]");
        }
        int statusCode = Integer.parseInt(matcher.group(1));
        String statusReason = matcher.group(2);
        if (statusCode != 200) {
            throw new IOException("HTTP proxy tunneling failed [" + statusCode + ":" + statusLine + "]");
        }
    }

    private static void doSOCKSTunneling(InetSocketAddress endPoint, SocketChannel socketChannel, Proxy proxy) throws IOException {
        ProxyHelper.checkEndPointAccessPermission(endPoint);
        ByteBuffer ioBuffer = ByteBuffer.allocate(512);
        ProxyHelper.doSOCKSAuthentication(endPoint, socketChannel, proxy, ioBuffer);
        ProxyHelper.doSOCKSConnect(endPoint, socketChannel, proxy, ioBuffer);
    }

    private static void doSOCKSAuthentication(InetSocketAddress epoint, SocketChannel socketChannel, Proxy proxy, ByteBuffer ioBuffer) throws IOException {
        ProxyHelper.writeAuthPacket(ioBuffer, socketChannel);
        int i2 = ProxyHelper.read(ioBuffer, socketChannel, 2);
        if (i2 == 2 && ioBuffer.get(0) == 5) {
            byte authType = ioBuffer.get(1);
            if (authType == -1) {
                throw new SocketException("Unknown SOCKS Authentication.");
            }
            if (!ProxyHelper.authenticate(authType, ioBuffer, socketChannel, proxy)) {
                throw new SocketException("SOCKS Authentication failure.");
            }
        } else {
            if (epoint.isUnresolved()) {
                throw new UnknownHostException(epoint.toString());
            }
            ProxyHelper.doSOCKSV4Connect(ioBuffer, socketChannel, epoint);
            return;
        }
    }

    private static void doSOCKSConnect(InetSocketAddress epoint, SocketChannel socketChannel, Proxy proxy, ByteBuffer ioBuffer) throws IOException {
        ProxyHelper.writeConnectPacket(ioBuffer, socketChannel, epoint);
        int i2 = ProxyHelper.read(ioBuffer, socketChannel, 4);
        if (i2 != 4) {
            throw new SocketException("SOCKS Bad response.");
        }
        if (ioBuffer.get(1) != 0) {
            throw new SocketException("SOCKS Connect Failure : " + ioBuffer.get(1));
        }
        ProxyHelper.processConnectSuccess(ioBuffer, socketChannel);
    }

    private static void checkEndPointAccessPermission(InetSocketAddress epoint) {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            if (epoint.isUnresolved()) {
                security.checkConnect(epoint.getHostName(), epoint.getPort());
            } else {
                security.checkConnect(epoint.getAddress().getHostAddress(), epoint.getPort());
            }
        }
    }

    private static void processConnectSuccess(ByteBuffer ioBuffer, SocketChannel sc) throws IOException {
        SocketException ex = null;
        byte socketAddrType = ioBuffer.get(3);
        switch (socketAddrType) {
            case 1: {
                byte[] addr = new byte[4];
                int i2 = ProxyHelper.read(ioBuffer, sc, 4);
                if (i2 != 4) {
                    throw new SocketException("SOCKS Bad response.");
                }
                ioBuffer.get(addr);
                i2 = ProxyHelper.read(ioBuffer, sc, 2);
                if (i2 == 2) break;
                throw new SocketException("SOCKS Bad response.");
            }
            case 3: {
                byte len = ioBuffer.get(1);
                byte[] host = new byte[len];
                int i3 = ProxyHelper.read(ioBuffer, sc, len);
                if (i3 != len) {
                    throw new SocketException("SOCKS Bad response.");
                }
                ioBuffer.get(host);
                i3 = ProxyHelper.read(ioBuffer, sc, 2);
                if (i3 == 2) break;
                throw new SocketException("SOCKS Bad response.");
            }
            case 4: {
                byte len = ioBuffer.get(1);
                byte[] addr = new byte[len];
                int i4 = ProxyHelper.read(ioBuffer, sc, len);
                if (i4 != len) {
                    throw new SocketException("SOCKS Bad response.");
                }
                ioBuffer.get(addr);
                i4 = ProxyHelper.read(ioBuffer, sc, 2);
                if (i4 == 2) break;
                throw new SocketException("SOCKS Bad response.");
            }
            default: {
                ex = new SocketException("SOCKS Bad response.");
            }
        }
    }

    private static void writeAuthPacket(ByteBuffer ioBuffer, SocketChannel sc) throws IOException {
        ioBuffer.clear();
        ioBuffer.put((byte)5);
        ioBuffer.put((byte)2);
        ioBuffer.put((byte)0);
        ioBuffer.put((byte)2);
        ioBuffer.flip();
        sc.write(ioBuffer);
    }

    private static void writeConnectPacket(ByteBuffer ioBuffer, SocketChannel sc, InetSocketAddress epoint) throws IOException {
        ioBuffer.clear();
        ioBuffer.put((byte)5);
        ioBuffer.put((byte)1);
        ioBuffer.put((byte)0);
        if (epoint.isUnresolved()) {
            ioBuffer.put((byte)3);
            ioBuffer.put((byte)epoint.getHostName().length());
            ioBuffer.put(epoint.getHostName().getBytes("ISO-8859-1"));
            ioBuffer.put((byte)(epoint.getPort() >> 8 & 0xFF));
            ioBuffer.put((byte)(epoint.getPort() >> 0 & 0xFF));
        } else if (epoint.getAddress() instanceof Inet6Address) {
            ioBuffer.put((byte)4);
            ioBuffer.put(epoint.getAddress().getAddress());
            ioBuffer.put((byte)(epoint.getPort() >> 8 & 0xFF));
            ioBuffer.put((byte)(epoint.getPort() >> 0 & 0xFF));
        } else {
            ioBuffer.put((byte)1);
            ioBuffer.put(epoint.getAddress().getAddress());
            ioBuffer.put((byte)(epoint.getPort() >> 8 & 0xFF));
            ioBuffer.put((byte)(epoint.getPort() >> 0 & 0xFF));
        }
        ioBuffer.flip();
        sc.write(ioBuffer);
    }

    private static int read(ByteBuffer ioBuffer, SocketChannel sc, int requiredBytes) throws IOException {
        ioBuffer.clear().limit(requiredBytes);
        for (int attempts = 0; ioBuffer.hasRemaining() && attempts < 3; ++attempts) {
            sc.read(ioBuffer);
            if (!ioBuffer.hasRemaining()) continue;
            throw new SocketException("Malformed reply from SOCKS server");
        }
        ioBuffer.flip();
        return ioBuffer.remaining();
    }

    private static boolean authenticate(int method, ByteBuffer ioBuffer, SocketChannel sc, Proxy proxy) throws IOException {
        if (method == 0) {
            return true;
        }
        if (method == 2) {
            String userName;
            InetAddress addr;
            int proxyPort;
            String password = null;
            String proxyHost = ((InetSocketAddress)proxy.address()).getHostString();
            PasswordAuthentication pw = ProxyHelper.getUserPassword(proxyHost, proxyPort = ((InetSocketAddress)proxy.address()).getPort(), addr = InetAddress.getByName(proxyHost));
            if (pw != null) {
                userName = pw.getUserName();
                password = new String(pw.getPassword());
            } else {
                userName = System.getProperty("user.name", "");
            }
            if (userName == null) {
                return false;
            }
            ioBuffer.clear();
            ioBuffer.put((byte)1);
            ioBuffer.put((byte)userName.length());
            ioBuffer.put(userName.getBytes("ISO-8859-1"));
            if (password != null) {
                ioBuffer.put((byte)password.length());
                ioBuffer.put(password.getBytes("ISO-8859-1"));
            } else {
                ioBuffer.put((byte)0);
            }
            ioBuffer.flip();
            sc.write(ioBuffer);
            int i2 = ProxyHelper.read(ioBuffer, sc, 2);
            return i2 == 2 && ioBuffer.get(1) == 0;
        }
        return false;
    }

    private static PasswordAuthentication getUserPassword(final String proxyHost, final int proxyPort, final InetAddress addr) {
        return AccessController.doPrivileged(new PrivilegedAction<PasswordAuthentication>(){
            private static Executable $$$methodRef$$$0;
            private static Logger $$$loggerRef$$$0;
            private static Executable $$$methodRef$$$1;
            private static Logger $$$loggerRef$$$1;
            private static Executable $$$methodRef$$$2;
            private static Logger $$$loggerRef$$$2;

            @Override
            public PasswordAuthentication run() {
                return Authenticator.requestPasswordAuthentication(proxyHost, addr, proxyPort, "SOCKS5", "SOCKS authentication", null);
            }

            static {
                try {
                    $$$methodRef$$$2 = 1.class.getDeclaredConstructor(String.class, InetAddress.class, Integer.TYPE);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$1 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
                try {
                    $$$methodRef$$$0 = 1.class.getDeclaredMethod("run", new Class[0]);
                }
                catch (Throwable throwable) {}
                $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
            }
        });
    }

    private static void doSOCKSV4Connect(ByteBuffer ioBuffer, SocketChannel sc, InetSocketAddress endpoint) throws IOException {
        if (!(endpoint.getAddress() instanceof Inet4Address)) {
            throw new SocketException("SOCKS V4 requires IPv4 only addresses");
        }
        ioBuffer.clear();
        ioBuffer.put((byte)4);
        ioBuffer.put((byte)1);
        ioBuffer.put((byte)(endpoint.getPort() >> 8 & 0xFF));
        ioBuffer.put((byte)(endpoint.getPort() >> 0 & 0xFF));
        ioBuffer.put(endpoint.getAddress().getAddress());
        String userName = System.getProperty("user.name", "");
        ioBuffer.put(userName.getBytes("ISO-8859-1"));
        ioBuffer.put((byte)0);
        ioBuffer.flip();
        sc.write(ioBuffer);
        int readLength = ProxyHelper.read(ioBuffer, sc, 8);
        if (readLength != 8) {
            throw new SocketException("Reply from SOCKS server has bad length: " + readLength);
        }
        if (ioBuffer.get(0) != 0 && ioBuffer.get(0) != 4) {
            throw new SocketException("Reply from SOCKS server has bad version");
        }
        switch (ioBuffer.get(1)) {
            case 91: {
                throw new SocketException("SOCKS Failure: request rejected.");
            }
            case 92: {
                throw new SocketException("SOCKS Failure: unable to connect to destination.");
            }
            case 93: {
                throw new SocketException("SOCKS Failure: authentication failed.");
            }
        }
        throw new SocketException("SOCKS Failure: bad status : " + ioBuffer.get(1));
    }

    static {
        try {
            $$$methodRef$$$13 = ProxyHelper.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = ProxyHelper.class.getDeclaredMethod("doSOCKSV4Connect", ByteBuffer.class, SocketChannel.class, InetSocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = ProxyHelper.class.getDeclaredMethod("getUserPassword", String.class, Integer.TYPE, InetAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = ProxyHelper.class.getDeclaredMethod("authenticate", Integer.TYPE, ByteBuffer.class, SocketChannel.class, Proxy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = ProxyHelper.class.getDeclaredMethod("read", ByteBuffer.class, SocketChannel.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = ProxyHelper.class.getDeclaredMethod("writeConnectPacket", ByteBuffer.class, SocketChannel.class, InetSocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = ProxyHelper.class.getDeclaredMethod("writeAuthPacket", ByteBuffer.class, SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = ProxyHelper.class.getDeclaredMethod("processConnectSuccess", ByteBuffer.class, SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = ProxyHelper.class.getDeclaredMethod("checkEndPointAccessPermission", InetSocketAddress.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = ProxyHelper.class.getDeclaredMethod("doSOCKSConnect", InetSocketAddress.class, SocketChannel.class, Proxy.class, ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = ProxyHelper.class.getDeclaredMethod("doSOCKSAuthentication", InetSocketAddress.class, SocketChannel.class, Proxy.class, ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = ProxyHelper.class.getDeclaredMethod("doSOCKSTunneling", InetSocketAddress.class, SocketChannel.class, Proxy.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = ProxyHelper.class.getDeclaredMethod("doHTTPTunneling", InetSocketAddress.class, SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = ProxyHelper.class.getDeclaredMethod("connectViaProxy", Proxy.class, InetSocketAddress.class, SocketChannel.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        HTTP_PROXY_STATUS_LINE_PATTERN = Pattern.compile("^HTTP/1.[01]\\s+(\\d+)\\s+(.*)", 2);
    }
}

