/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rules.ImmutableFilterTableScanRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.FilterableTable;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterTableScanRule
extends RelRule<Config> {
    @Deprecated
    public static final Predicate<TableScan> PREDICATE = FilterTableScanRule::test;

    protected FilterTableScanRule(Config config) {
        super(config);
    }

    @Deprecated
    protected FilterTableScanRule(RelOptRuleOperand operand, String description) {
        this(ImmutableFilterTableScanRule.Config.of().as(Config.class));
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected FilterTableScanRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        this(ImmutableFilterTableScanRule.Config.of().as(Config.class));
        throw new UnsupportedOperationException();
    }

    public static boolean test(TableScan scan) {
        RelOptTable table = scan.getTable();
        return table.unwrap(FilterableTable.class) != null || table.unwrap(ProjectableFilterableTable.class) != null;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        if (call.rels.length == 2) {
            Filter filter = (Filter)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            this.apply(call, filter, scan);
        } else if (call.rels.length == 3) {
            Filter filter = (Filter)call.rel(0);
            TableScan scan = (TableScan)call.rel(2);
            this.apply(call, filter, scan);
        } else {
            throw new AssertionError();
        }
    }

    protected void apply(RelOptRuleCall call, Filter filter, TableScan scan) {
        ImmutableIntList projects;
        ImmutableList.Builder filters = ImmutableList.builder();
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filters.addAll(bindableScan.filters);
            projects = bindableScan.projects;
        } else {
            projects = scan.identity();
        }
        Mapping mapping = Mappings.target(projects, scan.getTable().getRowType().getFieldCount());
        filters.add((Object)RexUtil.apply((Mappings.TargetMapping)mapping.inverse(), filter.getCondition()));
        call.transformTo(Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), (List<RexNode>)filters.build(), projects));
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterTableScanRule.Config.of().withOperandSupplier(b0 -> b0.operand(Filter.class).oneInput(b1 -> b1.operand(TableScan.class).predicate(FilterTableScanRule::test).noInputs()));
        public static final Config INTERPRETER = ImmutableFilterTableScanRule.Config.of().withOperandSupplier(b0 -> b0.operand(Filter.class).oneInput(b1 -> b1.operand(EnumerableInterpreter.class).oneInput(b2 -> b2.operand(TableScan.class).predicate(FilterTableScanRule::test).noInputs()))).withDescription("FilterTableScanRule:interpreter");

        @Override
        default public FilterTableScanRule toRule() {
            return new FilterTableScanRule(this);
        }
    }
}

