module Msf::Exploit::Remote::HTTP::Gitlab::Error
  # GitLab error mixin
  class ClientError < ::StandardError
    def initialize(message: nil)
      super(message || 'Gitlab Client Error')
    end
  end

  # Authentication error
  class AuthenticationError < ClientError
    def initialize
      super(message: 'Authentication failed')
    end
  end

  # Csrf token error
  class CsrfError < ClientError
    def initialize(message = 'Could not successfully extract CSRF token')
      super(message: message)
    end
  end

  # Group error
  class GroupError < ClientError
    def initialize(message)
      super(message: message)
    end
  end

  # Import error
  class ImportError < ClientError
    def initialize(message)
      super(message: message)
    end
  end

  # Version error
  class VersionError < ClientError
    def initialize
      super(message: 'Unable to determine Gitlab version')
    end
  end
end
