/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.shaper;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.border.Border;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.shaper.BaseButtonShaper;
import org.jvnet.substance.shaper.RectangularButtonShaper;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.border.SubstanceButtonBorder;

public class ClassicButtonShaper
extends BaseButtonShaper
implements RectangularButtonShaper {
    public static LazyResettableHashMap<GeneralPath> contours = new LazyResettableHashMap("ClassicButtonShaper");
    public static final ClassicButtonShaper INSTANCE = new ClassicButtonShaper();

    @Override
    public String getDisplayName() {
        return "Classic";
    }

    @Override
    public GeneralPath getButtonOutline(AbstractButton button, Insets insets, int width, int height) {
        Set<SubstanceConstants.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonside");
        float radius = this.getCornerRadius(button, insets);
        HashMapKey key = SubstanceCoreUtilities.getHashKey(width, height, straightSides, Float.valueOf(radius), insets);
        GeneralPath result = contours.get(key);
        if (result != null) {
            return result;
        }
        result = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, straightSides, insets);
        contours.put(key, result);
        return result;
    }

    @Override
    public Border getButtonBorder(final AbstractButton button) {
        return new SubstanceButtonBorder(ClassicButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component c) {
                int fontSize = SubstanceSizeUtils.getComponentFontSize(button);
                int extraPadding = SubstanceSizeUtils.getExtraPadding(fontSize);
                int focusPadding = SubstanceSizeUtils.getFocusRingPadding(fontSize);
                int lrPadding = SubstanceCoreUtilities.hasText(button) ? SubstanceSizeUtils.getTextButtonLRPadding(fontSize) : 0;
                Set<SubstanceConstants.Side> openSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonopenSide");
                int left = lrPadding + extraPadding + focusPadding + (openSides.contains((Object)SubstanceConstants.Side.LEFT) ? 1 : 2);
                int right = lrPadding + extraPadding + focusPadding + (openSides.contains((Object)SubstanceConstants.Side.RIGHT) ? 1 : 2);
                int top = extraPadding + (openSides.contains((Object)SubstanceConstants.Side.TOP) ? 1 : 2);
                int bottom = extraPadding + (openSides.contains((Object)SubstanceConstants.Side.BOTTOM) ? 1 : 2);
                return new Insets(top, left, bottom, right);
            }
        };
    }

    @Override
    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = SubstanceCoreUtilities.hasIcon(button);
        boolean hasText = SubstanceCoreUtilities.hasText(button);
        Insets margin = button.getMargin();
        Dimension result = uiPreferredSize;
        boolean hasNoMinSizeProperty = SubstanceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            baseWidth = Math.max(baseWidth, SubstanceSizeUtils.getMinButtonWidth(SubstanceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result.height;
            baseHeight = Math.max(baseHeight, SubstanceSizeUtils.getMinButtonHeight(SubstanceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(result.width, baseHeight);
        } else if (hasNoMinSizeProperty && margin != null) {
            result = new Dimension(result.width + margin.left + margin.right, result.height + margin.top + margin.bottom);
        }
        int fontSize = SubstanceSizeUtils.getComponentFontSize(button);
        int extraPadding = SubstanceSizeUtils.getExtraPadding(fontSize);
        int focusPadding = SubstanceSizeUtils.getFocusRingPadding(fontSize);
        int iconPaddingWidth = 6 + 2 * extraPadding + 2 * focusPadding;
        int iconPaddingHeight = 6 + 2 * extraPadding;
        if (margin != null) {
            iconPaddingWidth = Math.max(iconPaddingWidth, margin.left + margin.right);
            iconPaddingHeight = Math.max(iconPaddingHeight, margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - (double)iconPaddingHeight) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - (double)iconPaddingWidth) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (SubstanceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + iconPaddingWidth, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + iconPaddingHeight);
        }
        return result;
    }

    @Override
    public boolean isProportionate() {
        return true;
    }

    @Override
    public float getCornerRadius(AbstractButton button, Insets insets) {
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(button));
        if (SubstanceCoreUtilities.isToolBarButton(button)) {
            radius = SubstanceCoreUtilities.getToolbarButtonCornerRadius(button, insets);
        }
        return radius;
    }
}

