/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.view.JSChannel;
import org.jsampler.view.fantasia.Channel;
import org.jsampler.view.fantasia.ChannelView;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.FantasiaPrefs;
import org.jsampler.view.fantasia.HelpAboutDlg;
import org.jsampler.view.fantasia.InstrumentsDbFrame;
import org.jsampler.view.fantasia.LSConsoleFrame;
import org.jsampler.view.fantasia.MainFrame;
import org.jsampler.view.fantasia.MenuManager;
import org.jsampler.view.fantasia.NormalChannelView;
import org.jsampler.view.fantasia.PrefsDlg;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.SamplerInfoDlg;
import org.jsampler.view.fantasia.SmallChannelView;
import org.jsampler.view.fantasia.ViewConfig;
import org.jsampler.view.std.JSNewAudioDeviceDlg;
import org.jsampler.view.std.JSNewMidiDeviceDlg;
import org.jsampler.view.std.StdA4n;

public class A4n
extends StdA4n {
    protected static A4n a4n = new A4n();
    public final Action samplerInfo = new SamplerInfo();
    public final Action loadScript = new LoadLscpScript();
    public final Action createMidiDevice = new CreateMidiDevice();
    public final Action createAudioDevice = new CreateAudioDevice();
    public final Action editPreferences = new EditPreferences();
    public final Action setSmallView = new SetView(ChannelView.Type.SMALL);
    public final Action setNormalView = new SetView(ChannelView.Type.NORMAL);
    public final Action windowLSConsole = new WindowLSConsole();
    public final Action windowInstrumentsDb = new WindowInstrumentsDb();
    public final Action helpAbout = new HelpAbout();

    private A4n() {
        this.refresh.putValue("SmallIcon", Res.iconReload32);
        this.resetSampler.putValue("SmallIcon", Res.iconReset32);
        this.exportSamplerConfig.putValue("SmallIcon", Res.iconSave32);
    }

    @Override
    protected FantasiaPrefs preferences() {
        return FantasiaPrefs.preferences();
    }

    private class HelpAbout
    extends AbstractAction {
        HelpAbout() {
            super(FantasiaI18n.i18n.getMenuLabel("help.about", "Fantasia"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new HelpAboutDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    private class WindowInstrumentsDb
    extends AbstractAction {
        InstrumentsDbFrame instrumentsDbFrame;

        WindowInstrumentsDb() {
            super(FantasiaI18n.i18n.getMenuLabel("window.instrumentsDb"));
            this.instrumentsDbFrame = null;
            this.putValue("ShortDescription", FantasiaI18n.i18n.getMenuLabel("window.instrumentsDb.tt"));
            this.putValue("SmallIcon", Res.iconDb32);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CC.verifyConnection()) {
                return;
            }
            if (CC.getInstrumentsDbTreeModel() == null) {
                String string = FantasiaI18n.i18n.getMessage("A4n.noInstrumentsDbSupport!");
                HF.showErrorMessage(string, (Component)CC.getMainFrame());
                return;
            }
            if (this.instrumentsDbFrame != null) {
                this.instrumentsDbFrame.setVisible(false);
                this.instrumentsDbFrame.setVisible(true);
                return;
            }
            if (CC.getViewConfig().isUsingScreenMenuBar()) {
                ((ViewConfig)CC.getViewConfig()).setNativeMenuProperties();
                this.instrumentsDbFrame = new InstrumentsDbFrame();
                ((ViewConfig)CC.getViewConfig()).restoreMenuProperties();
            } else {
                this.instrumentsDbFrame = new InstrumentsDbFrame();
            }
            this.instrumentsDbFrame.setVisible(true);
        }
    }

    private class WindowLSConsole
    extends AbstractAction {
        WindowLSConsole() {
            super(FantasiaI18n.i18n.getMenuLabel("window.lsConsole"));
            this.putValue("ShortDescription", FantasiaI18n.i18n.getMenuLabel("window.lsConsole.tt"));
            this.putValue("SmallIcon", Res.iconLSConsole32);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LSConsoleFrame lSConsoleFrame = ((MainFrame)CC.getMainFrame()).getLSConsoleFrame();
            if (lSConsoleFrame.isVisible()) {
                lSConsoleFrame.setVisible(false);
            }
            lSConsoleFrame.setVisible(true);
        }
    }

    public static class SetView
    extends AbstractAction {
        private ChannelView.Type type;

        SetView(ChannelView.Type type) {
            this.type = type;
            switch (type) {
                case SMALL: {
                    this.putValue("Name", FantasiaI18n.i18n.getMenuLabel("channels.smallView"));
                    break;
                }
                case NORMAL: {
                    this.putValue("Name", FantasiaI18n.i18n.getMenuLabel("channels.normalView"));
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSChannel[] jSChannelArray;
            for (JSChannel jSChannel : jSChannelArray = CC.getMainFrame().getSelectedChannelsPane().getSelectedChannels()) {
                Channel channel = (Channel)jSChannel;
                if (channel.getViewTracker().getOriginalView().getType() == this.type) continue;
                channel.getViewTracker().setView(this.createView(this.type, channel));
            }
            MenuManager.getMenuManager().updateChannelViewGroups();
        }

        public static int getViewCount(ChannelView.Type type) {
            JSChannel[] jSChannelArray;
            int n = 0;
            for (JSChannel jSChannel : jSChannelArray = CC.getMainFrame().getSelectedChannelsPane().getSelectedChannels()) {
                Channel channel = (Channel)jSChannel;
                if (channel.getViewTracker().getOriginalView().getType() != type) continue;
                ++n;
            }
            return n;
        }

        public ChannelView createView(ChannelView.Type type, Channel channel) {
            switch (type) {
                case SMALL: {
                    return new SmallChannelView(channel);
                }
                case NORMAL: {
                    return new NormalChannelView(channel);
                }
            }
            throw new IllegalArgumentException("Unknown channel type");
        }
    }

    private class EditPreferences
    extends AbstractAction {
        EditPreferences() {
            super(FantasiaI18n.i18n.getMenuLabel("edit.preferences"));
            this.putValue("ShortDescription", FantasiaI18n.i18n.getMenuLabel("edit.preferences.tt"));
            this.putValue("SmallIcon", Res.iconPreferences32);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new PrefsDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    private class CreateAudioDevice
    extends AbstractAction {
        CreateAudioDevice() {
            super(FantasiaI18n.i18n.getMenuLabel("edit.createAudioDevice"));
            String string = FantasiaI18n.i18n.getMenuLabel("edit.createAudioDevice.tt");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CC.verifyConnection()) {
                return;
            }
            new JSNewAudioDeviceDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    private class CreateMidiDevice
    extends AbstractAction {
        CreateMidiDevice() {
            super(FantasiaI18n.i18n.getMenuLabel("edit.createMidiDevice"));
            String string = FantasiaI18n.i18n.getMenuLabel("edit.createMidiDevice.tt");
            this.putValue("ShortDescription", string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!CC.verifyConnection()) {
                return;
            }
            new JSNewMidiDeviceDlg(CC.getMainFrame()).setVisible(true);
        }
    }

    private class LoadLscpScript
    extends AbstractAction {
        LoadLscpScript() {
            super(FantasiaI18n.i18n.getMenuLabel("actions.runScript"));
            this.putValue("ShortDescription", FantasiaI18n.i18n.getMenuLabel("actions.runScript.tt"));
            this.putValue("SmallIcon", Res.iconOpen32);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!((MainFrame)CC.getMainFrame()).runScript()) {
                return;
            }
            if (A4n.this.preferences().getBoolProperty("showLSConsoleWhenRunScript")) {
                A4n.this.windowLSConsole.actionPerformed(null);
            }
        }
    }

    private static class SamplerInfo
    extends AbstractAction {
        SamplerInfo() {
            super(FantasiaI18n.i18n.getMenuLabel("actions.samplerInfo"));
            this.putValue("ShortDescription", FantasiaI18n.i18n.getMenuLabel("actions.samplerInfo.tt"));
            this.putValue("SmallIcon", Res.iconSamplerInfo32);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            new SamplerInfoDlg(CC.getMainFrame()).setVisible(true);
        }
    }
}

