/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.TaskPaneAddon;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public class JXTaskPane
extends JPanel
implements JXCollapsiblePane.CollapsiblePaneContainer {
    public static final String uiClassID = "swingx/TaskPaneUI";
    public static final String SCROLL_ON_EXPAND_CHANGED_KEY = "scrollOnExpand";
    public static final String TITLE_CHANGED_KEY = "title";
    public static final String ICON_CHANGED_KEY = "icon";
    public static final String SPECIAL_CHANGED_KEY = "special";
    public static final String ANIMATED_CHANGED_KEY = "animated";
    private String title;
    private Icon icon;
    private boolean special;
    private boolean collapsed;
    private boolean scrollOnExpand;
    private JXCollapsiblePane collapsePane = new JXCollapsiblePane();

    public JXTaskPane() {
        super.setLayout(new BorderLayout(0, 0));
        super.addImpl(this.collapsePane, "Center", -1);
        this.updateUI();
        this.setFocusable(true);
        this.setOpaque(false);
        this.setAnimated(!Boolean.FALSE.equals(UIManager.get("TaskPane.animate")));
        this.collapsePane.addPropertyChangeListener("animationState", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXTaskPane.this.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            }
        });
    }

    public Container getContentPane() {
        return this.collapsePane.getContentPane();
    }

    @Override
    public void updateUI() {
        if (this.collapsePane == null) {
            return;
        }
        this.setUI((TaskPaneUI)LookAndFeelAddons.getUI(this, TaskPaneUI.class));
    }

    public void setUI(TaskPaneUI taskPaneUI) {
        super.setUI(taskPaneUI);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        String string2 = this.title;
        this.title = string;
        this.firePropertyChange(TITLE_CHANGED_KEY, string2, string);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.icon;
        this.icon = icon;
        this.firePropertyChange(ICON_CHANGED_KEY, icon2, icon);
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void setSpecial(boolean bl) {
        boolean bl2 = this.isSpecial();
        this.special = bl;
        this.firePropertyChange(SPECIAL_CHANGED_KEY, bl2, this.isSpecial());
    }

    public void setScrollOnExpand(boolean bl) {
        boolean bl2 = this.isScrollOnExpand();
        this.scrollOnExpand = bl;
        this.firePropertyChange(SCROLL_ON_EXPAND_CHANGED_KEY, bl2, this.isScrollOnExpand());
    }

    public boolean isScrollOnExpand() {
        return this.scrollOnExpand;
    }

    public void setCollapsed(boolean bl) {
        boolean bl2 = this.isCollapsed();
        this.collapsed = bl;
        this.collapsePane.setCollapsed(bl);
        this.firePropertyChange("collapsed", bl2, this.isCollapsed());
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setAnimated(boolean bl) {
        boolean bl2 = this.isAnimated();
        this.collapsePane.setAnimated(bl);
        this.firePropertyChange(ANIMATED_CHANGED_KEY, bl2, this.isAnimated());
    }

    public boolean isAnimated() {
        return this.collapsePane.isAnimated();
    }

    public Component add(Action action) {
        Component component = ((TaskPaneUI)this.ui).createAction(action);
        this.add(component);
        return component;
    }

    @Override
    public Container getValidatingContainer() {
        return this.getParent();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        this.getContentPane().add(component, object, n);
        this.revalidate();
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.collapsePane != null) {
            this.getContentPane().setLayout(layoutManager);
        }
    }

    @Override
    public void remove(Component component) {
        this.getContentPane().remove(component);
    }

    @Override
    public void remove(int n) {
        this.getContentPane().remove(n);
    }

    @Override
    public void removeAll() {
        this.getContentPane().removeAll();
    }

    @Override
    protected String paramString() {
        return super.paramString() + ",title=" + this.getTitle() + ",icon=" + this.getIcon() + ",collapsed=" + String.valueOf(this.isCollapsed()) + ",special=" + String.valueOf(this.isSpecial()) + ",scrollOnExpand=" + String.valueOf(this.isScrollOnExpand()) + ",ui=" + this.getUI();
    }

    static {
        LookAndFeelAddons.contribute(new TaskPaneAddon());
    }
}

