/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.NumberFormat;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.juife.JuifeUtils;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.OrchestraInstrument;
import org.jsampler.SamplerChannelModel;
import org.jsampler.event.SamplerChannelEvent;
import org.jsampler.event.SamplerChannelListener;
import org.jsampler.view.JSChannel;
import org.jsampler.view.classic.ChannelProperties;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.ClassicPrefs;
import org.jsampler.view.classic.ClassicUtils;
import org.jsampler.view.classic.Res;
import org.jsampler.view.std.JSInstrumentChooser;
import org.linuxsampler.lscp.SamplerChannel;
import org.linuxsampler.lscp.SamplerEngine;

public class Channel
extends JSChannel {
    private static final ImageIcon iconEdit;
    private static final ImageIcon iconMuteOn;
    private static final ImageIcon iconMuteOff;
    private static final ImageIcon iconMutedBySolo;
    private static final ImageIcon iconSoloOn;
    private static final ImageIcon iconSoloOff;
    private static final ImageIcon iconShowProperties;
    private static final ImageIcon iconHideProperties;
    private static Border borderSelected;
    private static Border borderHighlighted;
    private static Border borderDeselected;
    private static Color chnColor;
    private static Color borderColor;
    private static Color borderHighlightedColor;
    private static Color chnSelectedColor;
    private static Color chnHighlightedColor;
    private static final Vector<PropertyChangeListener> propertyChangeListeners;
    private static NumberFormat numberFormat;
    private final JPanel mainPane = new JPanel();
    private final ChannelProperties propertiesPane;
    private final JButton btnInstr = new InstrumentButton(ClassicI18n.i18n.getLabel("Channel.btnInstr"));
    private final Action actInstr;
    private final JButton btnEdit = new JButton(iconEdit);
    private final JButton btnMute = new JButton();
    private final JButton btnSolo = new JButton();
    private final JSlider slVolume = new JSlider(0, 100);
    private final JLabel lVolume = new JLabel();
    private final JLabel lVolImg = new JLabel(Res.iconVolume16);
    private final JLabel lStreams = new JLabel("--");
    private final JLabel lVoices = new JLabel("--");
    private final JToggleButton btnProperties = new JToggleButton();
    private static int count;
    private boolean selected = false;
    private boolean mouseOver = false;
    private final EventHandler eventHandler = new EventHandler();

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        propertyChangeListeners.add(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        propertyChangeListeners.remove(propertyChangeListener);
    }

    public static Color getBorderColor() {
        return borderColor;
    }

    public static void setBorderColor(Color color) {
        if (borderColor != null && borderColor.getRGB() == color.getRGB()) {
            return;
        }
        Color color2 = borderColor;
        borderColor = color;
        borderSelected = new LineBorder(Channel.getBorderColor(), 2, true);
        Channel.firePropertyChanged("borderColor", color2, borderColor);
    }

    public static Color getBorderHighlightedColor() {
        return borderHighlightedColor;
    }

    public static void setBorderHighlightedColor(Color color) {
        Color color2 = borderHighlightedColor;
        if (color2 != null && color2.getRGB() == color.getRGB()) {
            return;
        }
        borderHighlightedColor = color;
        borderHighlighted = new LineBorder(Channel.getBorderHighlightedColor(), 2, true);
        Channel.firePropertyChanged("borderHighlightedColor", color2, borderHighlightedColor);
    }

    public static Color getSelectedChannelBgColor() {
        return chnSelectedColor;
    }

    public static void setSelectedChannelBgColor(Color color) {
        Color color2 = chnSelectedColor;
        if (color2 != null && color2.getRGB() == color.getRGB()) {
            return;
        }
        chnSelectedColor = color;
        Channel.firePropertyChanged("selectedChannelBgColor", color2, chnSelectedColor);
    }

    public static Color getHighlightedChannelBgColor() {
        return chnHighlightedColor;
    }

    public static void setHighlightedChannelBgColor(Color color) {
        Color color2 = chnHighlightedColor;
        if (color2 != null && color2.getRGB() == color.getRGB()) {
            return;
        }
        chnHighlightedColor = color;
        Channel.firePropertyChanged("highlightedChannelBgColor", color2, chnHighlightedColor);
    }

    private static void firePropertyChanged(String string, Object object, Object object2) {
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(Channel.class, string, object, object2);
        for (PropertyChangeListener propertyChangeListener : propertyChangeListeners) {
            propertyChangeListener.propertyChange(propertyChangeEvent);
        }
    }

    public Channel(SamplerChannelModel samplerChannelModel) {
        super(samplerChannelModel);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.mainPane.setLayout(new BoxLayout(this.mainPane, 1));
        this.addMouseListener(this.getHandler());
        this.addHierarchyListener(this.getHandler());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.setToolTipText(ClassicI18n.i18n.getLabel("Channel.tt", this.getModel().getChannelId()));
        Dimension dimension = this.btnInstr.getPreferredSize();
        this.btnInstr.setMaximumSize(new Dimension(Short.MAX_VALUE, dimension.height));
        jPanel.add(this.btnInstr);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.btnEdit.setToolTipText(ClassicI18n.i18n.getLabel("Channel.btnEdit.tt"));
        this.btnEdit.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add(this.btnEdit);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.lStreams.setHorizontalAlignment(0);
        this.lVoices.setHorizontalAlignment(0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setOpaque(false);
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel2.add(this.lStreams);
        jPanel2.add(new JLabel("/"));
        jPanel2.add(this.lVoices);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.btnMute.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add(this.btnMute);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.btnSolo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jPanel.add(this.btnSolo);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setOpaque(false);
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel3.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel3.add(this.lVolImg);
        jPanel3.add(Box.createRigidArea(new Dimension(1, 0)));
        dimension = this.slVolume.getPreferredSize();
        this.slVolume.setMaximumSize(new Dimension(dimension.width > 300 ? dimension.width : 300, dimension.height));
        this.slVolume.setOpaque(false);
        jPanel3.add(this.slVolume);
        this.lVolume.setBorder(BorderFactory.createEmptyBorder(3, 6, 3, 6));
        this.lVolume.setHorizontalAlignment(4);
        if (CC.getViewConfig().isMeasurementUnitDecibel()) {
            this.lVolume.setText("-30.0dB");
        } else {
            this.lVolume.setText("100%");
        }
        this.lVolume.setPreferredSize(this.lVolume.getPreferredSize());
        jPanel3.add(this.lVolume);
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.btnProperties.setContentAreaFilled(false);
        this.btnProperties.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.btnProperties.setIcon(iconShowProperties);
        this.btnProperties.setSelectedIcon(iconHideProperties);
        jPanel.add(this.btnProperties);
        this.mainPane.add(jPanel);
        this.propertiesPane = new ChannelProperties(samplerChannelModel);
        this.propertiesPane.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
        this.propertiesPane.setVisible(false);
        this.mainPane.add(this.propertiesPane);
        this.add(this.mainPane);
        dimension = this.getPreferredSize();
        this.setMaximumSize(new Dimension(this.getMaximumSize().width, dimension.height));
        int n = ClassicPrefs.preferences().getIntProperty("maximumChannelVolume");
        this.slVolume.setMaximum(n);
        String string = "maximumChannelVolume";
        ClassicPrefs.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                int n = ClassicPrefs.preferences().getIntProperty("maximumChannelVolume");
                Channel.this.slVolume.setMaximum(n);
            }
        });
        String string2 = "volMeasurementUnitDecibel";
        ClassicPrefs.preferences().addPropertyChangeListener(string2, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                boolean bl = ClassicPrefs.preferences().getBoolProperty("volMeasurementUnitDecibel");
                Channel.this.lVolume.setPreferredSize(null);
                if (bl) {
                    Channel.this.lVolume.setText("-30.0dB");
                } else {
                    Channel.this.lVolume.setText("100%");
                }
                Channel.this.lVolume.setPreferredSize(Channel.this.lVolume.getPreferredSize());
                Channel.this.updateVolume();
            }
        });
        this.getModel().addSamplerChannelListener(this.getHandler());
        this.actInstr = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (Channel.this.actInstr.isEnabled()) {
                    Channel.this.loadInstrument();
                }
            }
        };
        this.btnInstr.addActionListener(this.actInstr);
        this.btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CC.getSamplerModel().editBackendInstrument(Channel.this.getChannelId());
            }
        });
        this.btnMute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Channel.this.changeMute();
            }
        });
        this.btnSolo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Channel.this.changeSolo();
            }
        });
        this.slVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Channel.this.setVolume();
            }
        });
        this.btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Channel.this.showProperties(Channel.this.btnProperties.isSelected());
                String string = Channel.this.btnProperties.isSelected() ? ClassicI18n.i18n.getButtonLabel("Channel.ttHideProps") : ClassicI18n.i18n.getButtonLabel("Channel.ttShowProps");
                Channel.this.btnProperties.setToolTipText(string);
            }
        });
        this.btnProperties.setCursor(Cursor.getPredefinedCursor(12));
        String string3 = this.btnProperties.isSelected() ? ClassicI18n.i18n.getButtonLabel("Channel.ttHideProps") : ClassicI18n.i18n.getButtonLabel("Channel.ttShowProps");
        this.btnProperties.setToolTipText(string3);
        this.addPropertyChangeListener(this.getHandler());
        this.updateChannelInfo();
    }

    private EventHandler getHandler() {
        return this.eventHandler;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        this.updateColors(bl);
        this.selected = bl;
    }

    private void updateColors(boolean bl) {
        if (bl) {
            this.mainPane.setBorder(borderSelected);
            this.mainPane.setBackground(chnSelectedColor);
        } else if (this.mouseOver) {
            this.mainPane.setBorder(borderHighlighted);
            this.mainPane.setBackground(chnHighlightedColor);
        } else {
            this.mainPane.setBorder(borderDeselected);
            this.mainPane.setBackground(chnColor);
        }
    }

    public void collapseChannel() {
        if (this.btnProperties.isSelected()) {
            this.btnProperties.doClick();
        }
    }

    public void expandChannel() {
        if (!this.btnProperties.isSelected()) {
            this.btnProperties.doClick();
        }
    }

    private void updateChannelInfo() {
        boolean bl;
        SamplerChannel samplerChannel = this.getChannelInfo();
        int n = samplerChannel.getInstrumentStatus();
        if (n >= 0 && n < 100) {
            this.btnInstr.setText(ClassicI18n.i18n.getLabel("Channel.loadingInstrument", n));
        } else if (n == -1) {
            this.btnInstr.setText(ClassicI18n.i18n.getLabel("Channel.btnInstr"));
        } else if (n < -1) {
            this.btnInstr.setText(ClassicI18n.i18n.getLabel("Channel.errorLoadingInstrument"));
        } else if (samplerChannel.getInstrumentName() != null) {
            this.btnInstr.setText(samplerChannel.getInstrumentName());
        } else {
            this.btnInstr.setText(ClassicI18n.i18n.getLabel("Channel.btnInstr"));
        }
        boolean bl2 = bl = n == 100;
        if (this.btnEdit.isEnabled() != bl) {
            this.btnEdit.setEnabled(bl);
        }
        this.updateMuteIcon(samplerChannel);
        if (samplerChannel.isSoloChannel()) {
            this.btnSolo.setIcon(iconSoloOn);
        } else {
            this.btnSolo.setIcon(iconSoloOff);
        }
        this.slVolume.setValue((int)(samplerChannel.getVolume() * 100.0f));
        bl = samplerChannel.getEngine() != null;
        this.slVolume.setEnabled(bl);
        this.btnSolo.setEnabled(bl);
        this.btnMute.setEnabled(bl);
    }

    private void changeMute() {
        SamplerChannel samplerChannel = this.getChannelInfo();
        boolean bl = true;
        if (samplerChannel.isMuted() && !samplerChannel.isMutedBySolo()) {
            bl = false;
            boolean bl2 = CC.getSamplerModel().hasSoloChannel();
            if (samplerChannel.isSoloChannel() || !bl2) {
                this.btnMute.setIcon(iconMuteOff);
            } else {
                this.btnMute.setIcon(iconMutedBySolo);
            }
        } else {
            this.btnMute.setIcon(iconMuteOn);
        }
        this.getModel().setBackendMute(bl);
    }

    private void changeSolo() {
        boolean bl;
        SamplerChannel samplerChannel = this.getChannelInfo();
        boolean bl2 = bl = !samplerChannel.isSoloChannel();
        if (bl) {
            this.btnSolo.setIcon(iconSoloOn);
            if (samplerChannel.isMutedBySolo()) {
                this.btnMute.setIcon(iconMuteOff);
            }
        } else {
            this.btnSolo.setIcon(iconSoloOff);
            if (!samplerChannel.isMuted() && CC.getSamplerModel().getSoloChannelCount() > 1) {
                this.btnMute.setIcon(iconMutedBySolo);
            }
        }
        this.getModel().setBackendSolo(bl);
    }

    private void setVolume() {
        this.updateVolume();
        if (this.slVolume.getValueIsAdjusting()) {
            return;
        }
        int n = (int)(this.getChannelInfo().getVolume() * 100.0f);
        if (n == this.slVolume.getValue()) {
            return;
        }
        float f = this.slVolume.getValue();
        this.getModel().setBackendVolume(f /= 100.0f);
    }

    private void updateVolume() {
        int n = this.slVolume.getValue();
        if (CC.getViewConfig().isMeasurementUnitDecibel()) {
            String string = numberFormat.format(HF.percentsToDecibels(n));
            this.slVolume.setToolTipText(ClassicI18n.i18n.getLabel("Channel.volumeDecibels", string));
            this.lVolImg.setToolTipText(ClassicI18n.i18n.getLabel("Channel.volumeDecibels", string));
            this.lVolume.setText(string + "dB");
        } else {
            this.slVolume.setToolTipText(ClassicI18n.i18n.getLabel("Channel.volume", n));
            this.lVolImg.setToolTipText(ClassicI18n.i18n.getLabel("Channel.volume", n));
            this.lVolume.setText(String.valueOf(n) + '%');
        }
    }

    private void updateMuteIcon(SamplerChannel samplerChannel) {
        if (samplerChannel.isMutedBySolo()) {
            this.btnMute.setIcon(iconMutedBySolo);
        } else if (samplerChannel.isMuted()) {
            this.btnMute.setIcon(iconMuteOn);
        } else {
            this.btnMute.setIcon(iconMuteOff);
        }
    }

    private void updateStreamCount(int n) {
        Dimension dimension = this.lStreams.getPreferredSize();
        this.lStreams.setText(n == 0 ? "--" : String.valueOf(n));
        dimension = JuifeUtils.getUnionSize(dimension, this.lStreams.getPreferredSize());
        this.lStreams.setMinimumSize(dimension);
        this.lStreams.setPreferredSize(dimension);
        this.lStreams.setMaximumSize(dimension);
    }

    private void updateVoiceCount(int n) {
        Dimension dimension = this.lVoices.getPreferredSize();
        this.lVoices.setText(n == 0 ? "--" : String.valueOf(n));
        dimension = JuifeUtils.getUnionSize(dimension, this.lVoices.getPreferredSize());
        this.lVoices.setMinimumSize(dimension);
        this.lVoices.setPreferredSize(dimension);
        this.lVoices.setMaximumSize(dimension);
    }

    private void showProperties(boolean bl) {
        this.propertiesPane.setVisible(bl);
    }

    private void loadInstrument() {
        JSInstrumentChooser jSInstrumentChooser = ClassicUtils.createInstrumentChooser(CC.getMainFrame());
        jSInstrumentChooser.setVisible(true);
        if (jSInstrumentChooser.isCancelled()) {
            return;
        }
        SamplerEngine samplerEngine = this.getChannelInfo().getEngine();
        if (jSInstrumentChooser.getEngine() != null) {
            if (samplerEngine == null || !jSInstrumentChooser.getEngine().equals(samplerEngine.getName())) {
                // empty if block
            }
            this.getModel().setBackendEngineType(jSInstrumentChooser.getEngine());
        }
        int n = jSInstrumentChooser.getInstrumentIndex();
        this.getModel().loadBackendInstrument(jSInstrumentChooser.getInstrumentFile(), n);
    }

    static {
        propertyChangeListeners = new Vector();
        numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(1);
        iconEdit = new ImageIcon(Channel.class.getResource("res/icons/edit.png"));
        String string = "org/jsampler/view/classic/res/icons/";
        URL uRL = ClassLoader.getSystemClassLoader().getResource(string + "mute_on.png");
        iconMuteOn = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemClassLoader().getResource(string + "mute_off.png");
        iconMuteOff = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemClassLoader().getResource(string + "muted_by_solo.png");
        iconMutedBySolo = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemClassLoader().getResource(string + "solo_on.png");
        iconSoloOn = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemClassLoader().getResource(string + "solo_off.png");
        iconSoloOff = new ImageIcon(uRL);
        uRL = ClassLoader.getSystemClassLoader().getResource(string + "Back16.gif");
        iconShowProperties = new ImageIcon(uRL);
        iconHideProperties = Res.iconDown16;
        if (ClassicPrefs.getCustomChannelBorderColor()) {
            Channel.setBorderColor(ClassicPrefs.getChannelBorderColor());
        } else {
            Channel.setBorderColor(ClassicPrefs.getDefaultChannelBorderColor());
        }
        if (ClassicPrefs.getCustomChannelBorderHlColor()) {
            Channel.setBorderHighlightedColor(ClassicPrefs.getChannelBorderHlColor());
        } else {
            Channel.setBorderHighlightedColor(ClassicPrefs.getDefaultChannelBorderHlColor());
        }
        borderSelected = new LineBorder(Channel.getBorderColor(), 2, true);
        borderHighlighted = new LineBorder(Channel.getBorderHighlightedColor(), 2, true);
        borderDeselected = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        chnColor = new JPanel().getBackground();
        if (ClassicPrefs.getCustomSelectedChannelBgColor()) {
            chnSelectedColor = ClassicPrefs.getSelectedChannelBgColor();
        } else {
            int n = chnColor.getRed() - 14 < 0 ? 0 : chnColor.getRed() - 14;
            int n2 = chnColor.getGreen() - 8 < 0 ? 0 : chnColor.getGreen() - 8;
            int n3 = chnColor.getBlue() - 3 < 0 ? 0 : chnColor.getBlue() - 3;
            chnSelectedColor = new Color(n, n2, n3);
        }
        chnHighlightedColor = new Color(chnColor.getRGB());
        count = 2;
    }

    private class EventHandler
    extends MouseAdapter
    implements SamplerChannelListener,
    PropertyChangeListener,
    HierarchyListener {
        private EventHandler() {
        }

        @Override
        public void channelChanged(SamplerChannelEvent samplerChannelEvent) {
            Channel.this.updateChannelInfo();
        }

        @Override
        public void streamCountChanged(SamplerChannelEvent samplerChannelEvent) {
            Channel.this.updateStreamCount(Channel.this.getModel().getStreamCount());
        }

        @Override
        public void voiceCountChanged(SamplerChannelEvent samplerChannelEvent) {
            Channel.this.updateVoiceCount(Channel.this.getModel().getVoiceCount());
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "borderColor" || propertyChangeEvent.getPropertyName() == "borderHighlightedColor" || propertyChangeEvent.getPropertyName() == "selectedChannelBgColor" || propertyChangeEvent.getPropertyName() == "highlightedChannelBgColor") {
                Channel.this.updateColors(Channel.this.isSelected());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Channel.this.mouseOver = true;
            Channel.this.updateColors(Channel.this.isSelected());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (Channel.this.getMousePosition(true) != null) {
                return;
            }
            Channel.this.mouseOver = false;
            Channel.this.updateColors(Channel.this.isSelected());
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 4L) == 4L) {
                if (Channel.this.getMousePosition() == null) {
                    this.mouseExited(null);
                } else {
                    this.mouseEntered(null);
                }
            }
        }
    }

    public class InstrumentButton
    extends JButton {
        private boolean dragging;

        InstrumentButton(String string) {
            super(string);
            this.dragging = false;
            this.setTransferHandler(new TransferHandler("instrument"));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    if (!InstrumentButton.this.dragging) {
                        return;
                    }
                    int n = 1024;
                    if ((mouseEvent.getModifiersEx() & n) != n) {
                        return;
                    }
                    Channel.this.actInstr.setEnabled(false);
                    InstrumentButton.this.doClick(0);
                    Channel.this.actInstr.setEnabled(true);
                    JComponent jComponent = (JComponent)mouseEvent.getSource();
                    TransferHandler transferHandler = jComponent.getTransferHandler();
                    transferHandler.exportAsDrag(jComponent, mouseEvent, 1);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    InstrumentButton.this.dragging = false;
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    InstrumentButton.this.dragging = true;
                }
            });
        }

        public String getInstrument() {
            SamplerChannel samplerChannel = Channel.this.getChannelInfo();
            if (samplerChannel.getInstrumentName() == null || samplerChannel.getInstrumentStatus() < 0) {
                return null;
            }
            OrchestraInstrument orchestraInstrument = new OrchestraInstrument();
            orchestraInstrument.setName(samplerChannel.getInstrumentName());
            orchestraInstrument.setInstrumentIndex(samplerChannel.getInstrumentIndex());
            orchestraInstrument.setFilePath(samplerChannel.getInstrumentFile());
            return orchestraInstrument.getDnDString();
        }

        public void setInstrument(String string) {
            if (!OrchestraInstrument.isDnDString(string)) {
                return;
            }
            String[] stringArray = string.split("\n");
            if (stringArray.length < 6) {
                return;
            }
            try {
                int n = Integer.parseInt(stringArray[5]);
                Channel.this.getModel().loadBackendInstrument(stringArray[4], n);
            }
            catch (Exception exception) {
                CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
            }
        }
    }
}

