/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.jsampler.Server;
import org.jsampler.ServerList;

public class ServerTableModel
extends AbstractTableModel {
    private ServerList serverList;
    private final Handler eventHandler = new Handler();

    public ServerTableModel(ServerList serverList) {
        this.setServerList(serverList);
    }

    public ServerList getServerList() {
        return this.serverList;
    }

    public void setServerList(ServerList serverList) {
        if (serverList == null) {
            throw new IllegalArgumentException("serverList should be non-null!");
        }
        if (this.getServerList() != null) {
            this.getServerList().removeChangeListener(this.getHandler());
        }
        this.serverList = serverList;
        serverList.addChangeListener(this.getHandler());
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int n) {
        return " ";
    }

    @Override
    public int getRowCount() {
        return this.serverList.getServerCount();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.serverList.getServer(n);
    }

    public Server getServerAt(int n) {
        return this.serverList.getServer(n);
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements ChangeListener {
        private Handler() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ServerTableModel.this.fireTableDataChanged();
        }
    }
}

