/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.DefaultTextReportBuilder;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.logging.text.StreamingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.jspecify.annotations.Nullable;

public class TextReportRenderer
implements ReportRenderer {
    private @Nullable FileResolver fileResolver;
    private @Nullable StyledTextOutput textOutput;
    private @Nullable TextReportBuilder builder;
    private boolean close;

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    @Override
    public void setOutput(StyledTextOutput textOutput) {
        this.setWriter(textOutput, false);
    }

    @Override
    public void setOutputFile(File file) throws IOException {
        this.cleanupWriter();
        this.setWriter((StyledTextOutput)new StreamingStyledTextOutput((Appendable)Files.newBufferedWriter(file.toPath(), Charset.defaultCharset(), new OpenOption[0])), true);
    }

    @Override
    public void startProject(ProjectDetails project) {
        String header = this.createHeader(project);
        this.builder.heading(header);
    }

    protected String createHeader(ProjectDetails project) {
        return StringUtils.capitalize((String)project.getDisplayName());
    }

    @Override
    public void completeProject(ProjectDetails project) {
    }

    @Override
    public void complete() {
        this.cleanupWriter();
    }

    private void setWriter(StyledTextOutput styledTextOutput, boolean close) {
        this.textOutput = styledTextOutput;
        this.builder = new DefaultTextReportBuilder(this.textOutput, this.fileResolver);
        this.close = close;
    }

    private void cleanupWriter() {
        try {
            if (this.close) {
                CompositeStoppable.stoppable((Object[])new Object[]{this.textOutput}).stop();
            }
        }
        finally {
            this.textOutput = null;
        }
    }

    public @Nullable StyledTextOutput getTextOutput() {
        return this.textOutput;
    }

    public @Nullable TextReportBuilder getBuilder() {
        return this.builder;
    }
}

