/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dynamodb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionKeyAttributeMapCopier;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeEstimateRangeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ItemCollectionMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ItemCollectionMetrics> {
    private static final SdkField<Map<String, AttributeValue>> ITEM_COLLECTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ItemCollectionKey").getter(ItemCollectionMetrics.getter(ItemCollectionMetrics::itemCollectionKey)).setter(ItemCollectionMetrics.setter(Builder::itemCollectionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemCollectionKey").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> SIZE_ESTIMATE_RANGE_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SizeEstimateRangeGB").getter(ItemCollectionMetrics.getter(ItemCollectionMetrics::sizeEstimateRangeGB)).setter(ItemCollectionMetrics.setter(Builder::sizeEstimateRangeGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeEstimateRangeGB").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEM_COLLECTION_KEY_FIELD, SIZE_ESTIMATE_RANGE_GB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ItemCollectionMetrics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, AttributeValue> itemCollectionKey;
    private final List<Double> sizeEstimateRangeGB;

    private ItemCollectionMetrics(BuilderImpl builder) {
        this.itemCollectionKey = builder.itemCollectionKey;
        this.sizeEstimateRangeGB = builder.sizeEstimateRangeGB;
    }

    public final boolean hasItemCollectionKey() {
        return this.itemCollectionKey != null && !(this.itemCollectionKey instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> itemCollectionKey() {
        return this.itemCollectionKey;
    }

    public final boolean hasSizeEstimateRangeGB() {
        return this.sizeEstimateRangeGB != null && !(this.sizeEstimateRangeGB instanceof SdkAutoConstructList);
    }

    public final List<Double> sizeEstimateRangeGB() {
        return this.sizeEstimateRangeGB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItemCollectionKey() ? this.itemCollectionKey() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSizeEstimateRangeGB() ? this.sizeEstimateRangeGB() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ItemCollectionMetrics)) {
            return false;
        }
        ItemCollectionMetrics other = (ItemCollectionMetrics)obj;
        return this.hasItemCollectionKey() == other.hasItemCollectionKey() && Objects.equals(this.itemCollectionKey(), other.itemCollectionKey()) && this.hasSizeEstimateRangeGB() == other.hasSizeEstimateRangeGB() && Objects.equals(this.sizeEstimateRangeGB(), other.sizeEstimateRangeGB());
    }

    public final String toString() {
        return ToString.builder((String)"ItemCollectionMetrics").add("ItemCollectionKey", this.hasItemCollectionKey() ? this.itemCollectionKey() : null).add("SizeEstimateRangeGB", this.hasSizeEstimateRangeGB() ? this.sizeEstimateRangeGB() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ItemCollectionKey": {
                return Optional.ofNullable(clazz.cast(this.itemCollectionKey()));
            }
            case "SizeEstimateRangeGB": {
                return Optional.ofNullable(clazz.cast(this.sizeEstimateRangeGB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ItemCollectionKey", ITEM_COLLECTION_KEY_FIELD);
        map.put("SizeEstimateRangeGB", SIZE_ESTIMATE_RANGE_GB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ItemCollectionMetrics, T> g) {
        return obj -> g.apply((ItemCollectionMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, AttributeValue> itemCollectionKey = DefaultSdkAutoConstructMap.getInstance();
        private List<Double> sizeEstimateRangeGB = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ItemCollectionMetrics model) {
            this.itemCollectionKey(model.itemCollectionKey);
            this.sizeEstimateRangeGB(model.sizeEstimateRangeGB);
        }

        public final Map<String, AttributeValue.Builder> getItemCollectionKey() {
            Map<String, AttributeValue.Builder> result = ItemCollectionKeyAttributeMapCopier.copyToBuilder(this.itemCollectionKey);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setItemCollectionKey(Map<String, AttributeValue.BuilderImpl> itemCollectionKey) {
            this.itemCollectionKey = ItemCollectionKeyAttributeMapCopier.copyFromBuilder(itemCollectionKey);
        }

        @Override
        public final Builder itemCollectionKey(Map<String, AttributeValue> itemCollectionKey) {
            this.itemCollectionKey = ItemCollectionKeyAttributeMapCopier.copy(itemCollectionKey);
            return this;
        }

        public final Collection<Double> getSizeEstimateRangeGB() {
            if (this.sizeEstimateRangeGB instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sizeEstimateRangeGB;
        }

        public final void setSizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB = ItemCollectionSizeEstimateRangeCopier.copy(sizeEstimateRangeGB);
        }

        @Override
        public final Builder sizeEstimateRangeGB(Collection<Double> sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB = ItemCollectionSizeEstimateRangeCopier.copy(sizeEstimateRangeGB);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizeEstimateRangeGB(Double ... sizeEstimateRangeGB) {
            this.sizeEstimateRangeGB(Arrays.asList(sizeEstimateRangeGB));
            return this;
        }

        public ItemCollectionMetrics build() {
            return new ItemCollectionMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ItemCollectionMetrics> {
        public Builder itemCollectionKey(Map<String, AttributeValue> var1);

        public Builder sizeEstimateRangeGB(Collection<Double> var1);

        public Builder sizeEstimateRangeGB(Double ... var1);
    }
}

