/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.vfs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Properties;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

public class MavenPropertiesVirtualFile
extends VirtualFile {
    private final String myPath;
    @NotNull
    private final VirtualFileSystem myFS;
    private final byte[] myContent;

    public MavenPropertiesVirtualFile(String path, Properties properties, @NotNull VirtualFileSystem FS) {
        if (FS == null) {
            MavenPropertiesVirtualFile.$$$reportNull$$$0(0);
        }
        this.myPath = path;
        this.myFS = FS;
        this.myContent = MavenPropertiesVirtualFile.createContent(properties);
    }

    private static byte[] createContent(Properties properties) {
        StringBuilder builder2 = new StringBuilder();
        TreeSet<Object> sortedKeys = new TreeSet<Object>(properties.keySet());
        for (String string : sortedKeys) {
            builder2.append(StringUtil.escapeProperty((String)string, (boolean)true));
            builder2.append("=");
            builder2.append(StringUtil.escapeProperty((String)properties.getProperty(string), (boolean)false));
            builder2.append("\n");
        }
        return builder2.toString().getBytes(StandardCharsets.UTF_8);
    }

    @NotNull
    public String getName() {
        String string = this.myPath;
        if (string == null) {
            MavenPropertiesVirtualFile.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFS;
        if (virtualFileSystem == null) {
            MavenPropertiesVirtualFile.$$$reportNull$$$0(2);
        }
        return virtualFileSystem;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            MavenPropertiesVirtualFile.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public VirtualFile getParent() {
        return null;
    }

    public VirtualFile[] getChildren() {
        return null;
    }

    public byte @NotNull [] contentsToByteArray() throws IOException {
        if (this.myContent == null) {
            throw new IOException();
        }
        if (this.myContent == null) {
            MavenPropertiesVirtualFile.$$$reportNull$$$0(4);
        }
        return this.myContent;
    }

    public long getTimeStamp() {
        return -1L;
    }

    public long getModificationStamp() {
        return Arrays.hashCode(this.myContent);
    }

    public long getLength() {
        return this.myContent.length;
    }

    public void refresh(boolean asynchronous, boolean recursive, Runnable postRunnable) {
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        InputStream inputStream = VfsUtilCore.byteStreamSkippingBOM((byte[])this.myContent, (VirtualFile)this);
        if (inputStream == null) {
            MavenPropertiesVirtualFile.$$$reportNull$$$0(5);
        }
        return inputStream;
    }

    @NotNull
    public OutputStream getOutputStream(Object requestor, long newModificationStamp, long newTimeStamp) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "FS";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/vfs/MavenPropertiesVirtualFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSystem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

