/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard;

import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardDefaultTypesProvider;
import com.intellij.execution.dashboard.RunDashboardGroupingRule;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.dashboard.RunDashboardRunConfigurationStatus;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.services.ServiceEventListener;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.platform.execution.dashboard.PanelContentUI;
import com.intellij.platform.execution.dashboard.RunDashboardComponentWrapper;
import com.intellij.platform.execution.dashboard.RunDashboardServiceViewContributor;
import com.intellij.platform.execution.dashboard.RunDashboardTypePanel;
import com.intellij.platform.execution.dashboard.tree.RunConfigurationNode;
import com.intellij.platform.execution.dashboard.tree.RunDashboardStatusFilter;
import com.intellij.platform.execution.serviceView.ServiceViewManagerImpl;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.ContentUI;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@com.intellij.openapi.components.State(name="RunDashboard", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class RunDashboardManagerImpl
implements RunDashboardManager,
PersistentStateComponent<State> {
    private static final ExtensionPointName<RunDashboardCustomizer> CUSTOMIZER_EP_NAME = new ExtensionPointName("com.intellij.runDashboardCustomizer");
    private static final ExtensionPointName<RunDashboardDefaultTypesProvider> DEFAULT_TYPES_PROVIDER_EP_NAME = new ExtensionPointName("com.intellij.runDashboardDefaultTypesProvider");
    static final ExtensionPointName<RunDashboardGroupingRule> GROUPING_RULE_EP_NAME = new ExtensionPointName("com.intellij.runDashboardGroupingRule");
    private final Project myProject;
    private final ContentManager myContentManager;
    private final ContentManagerListener myServiceContentManagerListener;
    private State myState;
    private final Set<String> myTypes;
    private final Set<RunConfiguration> myHiddenConfigurations;
    private final Set<RunConfiguration> myShownConfigurations;
    private final Map<RunConfiguration, RunDashboardRunConfigurationStatus> myConfigurationStatuses;
    private volatile List<List<RunDashboardManager.RunDashboardService>> myServices;
    private final ReentrantReadWriteLock myServiceLock;
    private final RunDashboardStatusFilter myStatusFilter;
    private String myToolWindowId;
    private final Predicate<Content> myReuseCondition;
    private final AtomicBoolean myListenersInitialized;
    private RunDashboardComponentWrapper myContentWrapper;
    private JComponent myEmptyContent;
    private RunDashboardTypePanel myTypeContent;

    public RunDashboardManagerImpl(@NotNull Project project) {
        if (project == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myTypes = new HashSet<String>();
        this.myHiddenConfigurations = new HashSet<RunConfiguration>();
        this.myShownConfigurations = new HashSet<RunConfiguration>();
        this.myConfigurationStatuses = new ConcurrentHashMap<RunConfiguration, RunDashboardRunConfigurationStatus>();
        this.myServices = new SmartList();
        this.myServiceLock = new ReentrantReadWriteLock();
        this.myStatusFilter = new RunDashboardStatusFilter();
        this.myListenersInitialized = new AtomicBoolean();
        this.myProject = project;
        ContentFactory contentFactory = ContentFactory.getInstance();
        this.myContentManager = contentFactory.createContentManager((ContentUI)new PanelContentUI(), false, project);
        this.myServiceContentManagerListener = new ServiceContentManagerListener();
        this.myReuseCondition = this::canReuseContent;
        this.initExtensionPointListeners();
        this.myContentManager.addContentManagerListener(new ContentManagerListener(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RunDashboardManagerImpl.this.initServiceContentListeners();
                RunDashboardManagerImpl.this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$1", "contentAdded"));
            }
        });
    }

    private void initExtensionPointListeners() {
        final ExtensionPointListener dashboardUpdater = new ExtensionPointListener(){

            public void extensionAdded(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                RunDashboardManagerImpl.this.updateDashboard(true);
            }

            public void extensionRemoved(@NotNull Object extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (extension == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                ((ServiceEventListener)RunDashboardManagerImpl.this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createUnloadSyncResetEvent(RunDashboardServiceViewContributor.class));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "extension";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        CUSTOMIZER_EP_NAME.addExtensionPointListener(dashboardUpdater, (Disposable)this.myProject);
        GROUPING_RULE_EP_NAME.addExtensionPointListener(dashboardUpdater, (Disposable)this.myProject);
        DEFAULT_TYPES_PROVIDER_EP_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<RunDashboardDefaultTypesProvider>(){

            public void extensionAdded(RunDashboardDefaultTypesProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(0);
                }
                HashSet<String> types = new HashSet<String>(RunDashboardManagerImpl.this.getTypes());
                types.addAll(extension.getDefaultTypeIds(RunDashboardManagerImpl.this.myProject));
                RunDashboardManagerImpl.this.setTypes(types);
            }

            public void extensionRemoved(RunDashboardDefaultTypesProvider extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    3.$$$reportNull$$$0(1);
                }
                HashSet<String> types = new HashSet<String>(RunDashboardManagerImpl.this.getTypes());
                types.removeAll(extension.getDefaultTypeIds(RunDashboardManagerImpl.this.myProject));
                RunDashboardManagerImpl.this.setTypes(types);
                dashboardUpdater.extensionRemoved((Object)extension, pluginDescriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myProject);
        ConfigurationType.CONFIGURATION_TYPE_EP.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<ConfigurationType>(){

            public void extensionAdded(ConfigurationType extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(0);
                }
                RunDashboardManagerImpl.this.setTypes(new HashSet<String>(RunDashboardManagerImpl.this.getTypes()));
            }

            public void extensionRemoved(ConfigurationType extension, @NotNull PluginDescriptor pluginDescriptor) {
                if (pluginDescriptor == null) {
                    4.$$$reportNull$$$0(1);
                }
                HashSet<String> types = new HashSet<String>(RunDashboardManagerImpl.this.getTypes());
                types.remove(extension.getId());
                RunDashboardManagerImpl.this.setTypes(types);
                dashboardUpdater.extensionRemoved((Object)extension, pluginDescriptor);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "pluginDescriptor";
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, (Disposable)this.myProject);
    }

    private void initServiceContentListeners() {
        if (!this.myListenersInitialized.compareAndSet(false, true)) {
            return;
        }
        MessageBusConnection connection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
        connection.subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){
            private volatile boolean myUpdateStarted;

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (settings.isTemporary() && RunDashboardManagerImpl.this.myState.excludedNewTypes.contains(settings.getType().getId())) {
                    RunDashboardManagerImpl.this.myShownConfigurations.add(settings.getConfiguration());
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.syncConfigurations();
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    5.$$$reportNull$$$0(1);
                }
                RunConfiguration configuration = settings.getConfiguration();
                RunDashboardManagerImpl.this.myHiddenConfigurations.remove(configuration);
                RunDashboardManagerImpl.this.myShownConfigurations.remove(configuration);
                RunDashboardManagerImpl.this.myConfigurationStatuses.remove(configuration);
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.syncConfigurations();
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                if (settings == null) {
                    5.$$$reportNull$$$0(2);
                }
                if (!this.myUpdateStarted) {
                    RunDashboardManagerImpl.this.updateDashboardIfNeeded(settings);
                }
            }

            public void beginUpdate() {
                this.myUpdateStarted = true;
            }

            public void endUpdate() {
                this.myUpdateStarted = false;
                RunDashboardManagerImpl.this.syncConfigurations();
                RunDashboardManagerImpl.this.updateDashboard(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$5";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    6.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    6.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    6.$$$reportNull$$$0(2);
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                RunConfiguration configuration;
                if (executorId == null) {
                    6.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    6.$$$reportNull$$$0(4);
                }
                if (handler == null) {
                    6.$$$reportNull$$$0(5);
                }
                RunConfiguration runConfiguration = configuration = env.getRunnerAndConfigurationSettings() != null ? env.getRunnerAndConfigurationSettings().getConfiguration() : null;
                if (configuration != null && RunDashboardManagerImpl.this.isShowInDashboard(configuration)) {
                    boolean stopped = exitCode == 0 || handler.getUserData(ProcessHandler.TERMINATION_REQUESTED) == Boolean.TRUE;
                    RunDashboardRunConfigurationStatus status = stopped ? RunDashboardRunConfigurationStatus.STOPPED : RunDashboardRunConfigurationStatus.FAILED;
                    RunDashboardManagerImpl.this.myConfigurationStatuses.put(configuration, status);
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(env.getRunnerAndConfigurationSettings());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$6";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        connection.subscribe(DASHBOARD_TOPIC, (Object)new RunDashboardListener(){

            public void configurationChanged(@NotNull RunConfiguration configuration, boolean withStructure) {
                if (configuration == null) {
                    7.$$$reportNull$$$0(0);
                }
                RunDashboardManagerImpl.this.updateDashboardIfNeeded(configuration, withStructure);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$7", "configurationChanged"));
            }
        });
        connection.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                RunDashboardManagerImpl.this.updateDashboard(false);
            }
        });
        this.myContentManager.addContentManagerListener(this.myServiceContentManagerListener);
    }

    public ContentManager getDashboardContentManager() {
        return this.myContentManager;
    }

    @NotNull
    public String getToolWindowId() {
        if (this.myToolWindowId == null) {
            String toolWindowId;
            this.myToolWindowId = LightEdit.owns((Project)this.myProject) ? "Services" : ((toolWindowId = ServiceViewManager.getInstance((Project)this.myProject).getToolWindowId(RunDashboardServiceViewContributor.class)) != null ? toolWindowId : "Services");
        }
        String string = this.myToolWindowId;
        if (string == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public Icon getToolWindowIcon() {
        Icon icon = AllIcons.Toolwindows.ToolWindowServices;
        if (icon == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(2);
        }
        return icon;
    }

    public List<RunDashboardManager.RunDashboardService> getRunConfigurations() {
        this.myServiceLock.readLock().lock();
        try {
            List<RunDashboardManager.RunDashboardService> list = this.myServices.stream().flatMap(Collection::stream).collect(Collectors.toList());
            return list;
        }
        finally {
            this.myServiceLock.readLock().unlock();
        }
    }

    private @Unmodifiable List<RunContentDescriptor> filterByContent(List<? extends RunContentDescriptor> descriptors) {
        return ContainerUtil.filter(descriptors, descriptor -> {
            Content content = descriptor.getAttachedContent();
            return content != null && content.getManager() == this.myContentManager;
        });
    }

    public boolean isShowInDashboard(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(3);
        }
        if (this.isShown(runConfiguration)) {
            return true;
        }
        RunConfiguration baseConfiguration = RunDashboardManagerImpl.getBaseConfiguration(runConfiguration);
        if (baseConfiguration != null) {
            return this.isShown(baseConfiguration);
        }
        return false;
    }

    private boolean isShown(@NotNull RunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(4);
        }
        if (!this.myTypes.contains(runConfiguration.getType().getId())) {
            return false;
        }
        if (this.myState.excludedNewTypes.contains(runConfiguration.getType().getId())) {
            return this.myShownConfigurations.contains(runConfiguration);
        }
        return !this.myHiddenConfigurations.contains(runConfiguration);
    }

    @Nullable
    private static RunConfiguration getBaseConfiguration(@NotNull RunConfiguration runConfiguration) {
        RunProfile runProfile;
        if (runConfiguration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(5);
        }
        return (runProfile = ExecutionManagerImpl.getDelegatedRunProfile((RunProfile)runConfiguration)) instanceof RunConfiguration ? (RunConfiguration)runProfile : null;
    }

    @NotNull
    public @Unmodifiable Set<String> getTypes() {
        Set<String> set = Collections.unmodifiableSet(this.myTypes);
        if (set == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(6);
        }
        return set;
    }

    public void setTypes(@NotNull Set<String> types) {
        if (types == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(7);
        }
        HashSet removed = new HashSet(Sets.difference(this.myTypes, types));
        HashSet added = new HashSet(Sets.difference(types, this.myTypes));
        this.myTypes.clear();
        this.myTypes.addAll(types);
        if (!this.myTypes.isEmpty()) {
            this.initServiceContentListeners();
        }
        Set<String> enableByDefaultTypes = this.getEnableByDefaultTypes();
        this.myState.configurationTypes.clear();
        this.myState.configurationTypes.addAll(this.myTypes);
        this.myState.configurationTypes.removeAll(enableByDefaultTypes);
        this.myState.excludedTypes.clear();
        this.myState.excludedTypes.addAll(enableByDefaultTypes);
        this.myState.excludedTypes.removeAll(this.myTypes);
        this.myState.excludedNewTypes.retainAll(types);
        this.myHiddenConfigurations.removeIf(configuration -> !types.contains(configuration.getType().getId()));
        this.myShownConfigurations.removeIf(configuration -> !types.contains(configuration.getType().getId()));
        this.myConfigurationStatuses.entrySet().removeIf(configuration -> !types.contains(((RunConfiguration)configuration.getKey()).getType().getId()));
        this.syncConfigurations();
        if (!removed.isEmpty()) {
            AppUIUtil.invokeOnEdt(() -> this.moveRemovedContent(RunDashboardManagerImpl.getContainsTypeIdCondition(removed)), (Condition)this.myProject.getDisposed());
        }
        if (!added.isEmpty()) {
            AppUIUtil.invokeOnEdt(() -> this.moveAddedContent(RunDashboardManagerImpl.getContainsTypeIdCondition(added)), (Condition)this.myProject.getDisposed());
        }
        this.updateDashboard(true);
    }

    private static Condition<? super RunnerAndConfigurationSettings> getContainsTypeIdCondition(Collection<String> types) {
        return settings -> {
            if (types.contains(settings.getType().getId())) {
                return true;
            }
            RunConfiguration baseConfiguration = RunDashboardManagerImpl.getBaseConfiguration(settings.getConfiguration());
            if (baseConfiguration != null) {
                return types.contains(baseConfiguration.getType().getId());
            }
            return false;
        };
    }

    private void moveRemovedContent(Condition<? super RunnerAndConfigurationSettings> condition) {
        RunContentManagerImpl runContentManager = (RunContentManagerImpl)RunContentManager.getInstance((Project)this.myProject);
        for (RunDashboardManager.RunDashboardService service : this.getRunConfigurations()) {
            Executor executor;
            RunContentDescriptor descriptor;
            Content content = service.getContent();
            if (content == null || !condition.value((Object)service.getSettings()) || (descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content)) == null || (executor = RunContentManagerImpl.getExecutorByContent((Content)content)) == null) continue;
            descriptor.setContentToolWindowId(null);
            RunDashboardManagerImpl.updateContentToolbar(content, true);
            runContentManager.moveContent(executor, descriptor);
        }
    }

    private void moveAddedContent(Condition<? super RunnerAndConfigurationSettings> condition) {
        RunContentManagerImpl runContentManager = (RunContentManagerImpl)RunContentManager.getInstance((Project)this.myProject);
        List descriptors = ExecutionManager.getInstance((Project)this.myProject).getRunningDescriptors(condition);
        for (RunContentDescriptor descriptor : descriptors) {
            Executor executor;
            Content content = descriptor.getAttachedContent();
            if (content == null || (executor = RunContentManagerImpl.getExecutorByContent((Content)content)) == null) continue;
            descriptor.setContentToolWindowId(this.getToolWindowId());
            runContentManager.moveContent(executor, descriptor);
        }
    }

    public Set<RunConfiguration> getHiddenConfigurations() {
        HashSet<RunConfiguration> hiddenConfigurations = new HashSet<RunConfiguration>(this.myHiddenConfigurations);
        for (String typeId : this.myState.excludedNewTypes) {
            hiddenConfigurations.addAll(this.getExcludedConfigurations(typeId, this.myShownConfigurations));
        }
        return hiddenConfigurations;
    }

    private Collection<RunConfiguration> getExcludedConfigurations(String typeId, Collection<RunConfiguration> toExclude) {
        ConfigurationType type = ConfigurationTypeUtil.findConfigurationType((String)typeId);
        if (type == null) {
            return Collections.emptyList();
        }
        List configurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList(type);
        return ContainerUtil.filter((Collection)configurations, configuration -> !toExclude.contains(configuration));
    }

    public void hideConfigurations(Collection<? extends RunConfiguration> configurations) {
        for (RunConfiguration runConfiguration : configurations) {
            if (this.myState.excludedNewTypes.contains(runConfiguration.getType().getId())) {
                this.myShownConfigurations.remove(runConfiguration);
                continue;
            }
            this.myHiddenConfigurations.add(runConfiguration);
        }
        this.syncConfigurations();
        if (!configurations.isEmpty()) {
            this.moveRemovedContent((Condition<? super RunnerAndConfigurationSettings>)((Condition)settings -> configurations.contains(settings.getConfiguration()) || configurations.contains(RunDashboardManagerImpl.getBaseConfiguration(settings.getConfiguration()))));
        }
        if (this.myTypeContent != null) {
            this.myTypeContent.setType(this.myTypeContent.getType());
        }
        this.updateDashboard(true);
    }

    public void restoreConfigurations(Collection<? extends RunConfiguration> configurations) {
        for (RunConfiguration runConfiguration : configurations) {
            if (this.myState.excludedNewTypes.contains(runConfiguration.getType().getId())) {
                this.myShownConfigurations.add(runConfiguration);
                continue;
            }
            this.myHiddenConfigurations.remove(runConfiguration);
        }
        this.syncConfigurations();
        if (!configurations.isEmpty()) {
            this.moveAddedContent((Condition<? super RunnerAndConfigurationSettings>)((Condition)settings -> configurations.contains(settings.getConfiguration()) || configurations.contains(RunDashboardManagerImpl.getBaseConfiguration(settings.getConfiguration()))));
        }
        if (this.myTypeContent != null) {
            this.myTypeContent.setType(this.myTypeContent.getType());
        }
        this.updateDashboard(true);
    }

    public boolean isNewExcluded(String typeId) {
        return this.myState.excludedNewTypes.contains(typeId);
    }

    public void setNewExcluded(String typeId, boolean newExcluded) {
        if (newExcluded) {
            if (this.myState.excludedNewTypes.add(typeId)) {
                this.invert(typeId, this.myHiddenConfigurations, this.myShownConfigurations);
                this.updateDashboard(true);
            }
        } else if (this.myState.excludedNewTypes.remove(typeId)) {
            this.invert(typeId, this.myShownConfigurations, this.myHiddenConfigurations);
            this.updateDashboard(true);
        }
    }

    public void clearConfigurationStatus(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(8);
        }
        this.myConfigurationStatuses.remove(configuration);
        this.updateDashboardIfNeeded(configuration, false);
    }

    @Nullable
    public RunDashboardRunConfigurationStatus getPersistedStatus(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(9);
        }
        return this.myConfigurationStatuses.get(configuration);
    }

    private void invert(String typeId, Set<RunConfiguration> from, Set<RunConfiguration> to) {
        to.addAll(this.getExcludedConfigurations(typeId, from));
        from.removeIf(configuration -> configuration.getType().getId().equals(typeId));
    }

    public boolean isOpenRunningConfigInNewTab() {
        return this.myState.openRunningConfigInTab;
    }

    public void setOpenRunningConfigInNewTab(boolean value) {
        this.myState.openRunningConfigInTab = value;
    }

    @NotNull
    static List<RunDashboardCustomizer> getCustomizers(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        if (settings == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(10);
        }
        SmartList customizers = new SmartList();
        for (RunDashboardCustomizer customizer : (RunDashboardCustomizer[])CUSTOMIZER_EP_NAME.getExtensions()) {
            if (!customizer.isApplicable(settings, descriptor)) continue;
            customizers.add(customizer);
        }
        SmartList smartList = customizers;
        if (smartList == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(11);
        }
        return smartList;
    }

    private void updateDashboardIfNeeded(@Nullable RunnerAndConfigurationSettings settings) {
        if (settings != null) {
            this.updateDashboardIfNeeded(settings.getConfiguration(), true);
        }
    }

    private void updateDashboardIfNeeded(@NotNull RunConfiguration configuration, boolean withStructure) {
        if (configuration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(12);
        }
        if (this.isShowInDashboard(configuration) || !this.filterByContent(this.getConfigurationDescriptors(configuration)).isEmpty()) {
            this.updateDashboard(withStructure);
        }
    }

    private List<RunContentDescriptor> getConfigurationDescriptors(@NotNull RunConfiguration configuration) {
        ExecutionManager instance;
        if (configuration == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(13);
        }
        if (!((instance = ExecutionManager.getInstance((Project)this.myProject)) instanceof ExecutionManagerImpl)) {
            return Collections.emptyList();
        }
        return ((ExecutionManagerImpl)instance).getDescriptors(s -> configuration.equals(s.getConfiguration()) || configuration.equals(RunDashboardManagerImpl.getBaseConfiguration(s.getConfiguration())));
    }

    @NotNull
    public Predicate<Content> getReuseCondition() {
        Predicate<Content> predicate = this.myReuseCondition;
        if (predicate == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(14);
        }
        return predicate;
    }

    private boolean canReuseContent(Content content) {
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
        if (descriptor == null) {
            return false;
        }
        ExecutionManagerImpl executionManager = ExecutionManagerImpl.getInstance((Project)this.myProject);
        Set descriptorConfigurations = executionManager.getConfigurations(descriptor);
        if (descriptorConfigurations.isEmpty()) {
            return true;
        }
        HashSet storedConfigurations = new HashSet(RunManager.getInstance((Project)this.myProject).getAllConfigurationsList());
        return !ContainerUtil.exists((Iterable)descriptorConfigurations, descriptorConfiguration -> {
            RunConfiguration configuration = descriptorConfiguration.getConfiguration();
            return this.isShowInDashboard(configuration) && storedConfigurations.contains(configuration);
        });
    }

    public void updateDashboard(boolean withStructure) {
        ((ServiceEventListener)this.myProject.getMessageBus().syncPublisher(ServiceEventListener.TOPIC)).handle(ServiceEventListener.ServiceEvent.createResetEvent(RunDashboardServiceViewContributor.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncConfigurations() {
        List settingsList = ContainerUtil.filter((Collection)RunManager.getInstance((Project)this.myProject).getAllSettings(), settings -> this.isShowInDashboard(settings.getConfiguration()));
        ArrayList<List<RunDashboardManager.RunDashboardService>> result = new ArrayList<List<RunDashboardManager.RunDashboardService>>();
        this.myServiceLock.writeLock().lock();
        try {
            for (RunnerAndConfigurationSettings runnerAndConfigurationSettings : settingsList) {
                SmartList syncedServices = this.getServices(runnerAndConfigurationSettings);
                if (syncedServices == null) {
                    syncedServices = new SmartList((Object)new RunDashboardServiceImpl(runnerAndConfigurationSettings, null));
                }
                result.add((List<RunDashboardManager.RunDashboardService>)syncedServices);
            }
            for (List list : this.myServices) {
                RunDashboardManager.RunDashboardService oldService = (RunDashboardManager.RunDashboardService)list.get(0);
                if (oldService.getContent() == null || settingsList.contains(oldService.getSettings()) || RunDashboardManagerImpl.updateServiceSettings(result, list)) continue;
                result.add(list);
            }
            this.myServices = result;
        }
        finally {
            this.myServiceLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RunDashboardManager.RunDashboardService addServiceContent(@NotNull Content content) {
        RunnerAndConfigurationSettings settings;
        if (content == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(15);
        }
        if ((settings = this.findSettings(content)) == null) {
            return null;
        }
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardManager.RunDashboardService runDashboardService = this.doAddServiceContent(settings, content);
            return runDashboardService;
        }
        finally {
            this.myServiceLock.writeLock().unlock();
        }
    }

    private void removeServiceContent(@NotNull Content content) {
        if (content == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(16);
        }
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardManager.RunDashboardService service = this.findService(content);
            if (service == null) {
                return;
            }
            this.doRemoveServiceContent(service);
        }
        finally {
            this.myServiceLock.writeLock().unlock();
            this.updateDashboard(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServiceContent(@NotNull Content content) {
        RunnerAndConfigurationSettings settings;
        if (content == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(17);
        }
        if ((settings = this.findSettings(content)) == null) {
            return;
        }
        this.myServiceLock.writeLock().lock();
        try {
            RunDashboardManager.RunDashboardService service = this.findService(content);
            if (service == null || service.getSettings().equals(settings)) {
                return;
            }
            this.doAddServiceContent(settings, content);
            this.doRemoveServiceContent(service);
        }
        finally {
            this.myServiceLock.writeLock().unlock();
        }
    }

    @NotNull
    private RunDashboardManager.RunDashboardService doAddServiceContent(@NotNull RunnerAndConfigurationSettings settings, @NotNull Content content) {
        SmartList settingsServices;
        if (settings == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(18);
        }
        if (content == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(19);
        }
        if ((settingsServices = this.getServices(settings)) == null) {
            RunDashboardServiceImpl newService = new RunDashboardServiceImpl(settings, content);
            settingsServices = new SmartList((Object)newService);
            this.myServices.add((List<RunDashboardManager.RunDashboardService>)settingsServices);
            RunDashboardServiceImpl runDashboardServiceImpl = newService;
            if (runDashboardServiceImpl == null) {
                RunDashboardManagerImpl.$$$reportNull$$$0(20);
            }
            return runDashboardServiceImpl;
        }
        RunDashboardManager.RunDashboardService service = settingsServices.get(0);
        if (service.getContent() == null && service instanceof RunDashboardServiceImpl) {
            RunDashboardServiceImpl mainService = (RunDashboardServiceImpl)service;
            mainService.setContent(content);
            RunDashboardServiceImpl runDashboardServiceImpl = mainService;
            if (runDashboardServiceImpl == null) {
                RunDashboardManagerImpl.$$$reportNull$$$0(21);
            }
            return runDashboardServiceImpl;
        }
        AdditionalRunDashboardService newService = new AdditionalRunDashboardService(settings, content);
        settingsServices.add(newService);
        AdditionalRunDashboardService additionalRunDashboardService = newService;
        if (additionalRunDashboardService == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(22);
        }
        return additionalRunDashboardService;
    }

    private void doRemoveServiceContent(@NotNull RunDashboardManager.RunDashboardService service) {
        RunnerAndConfigurationSettings contentSettings;
        List<RunDashboardManager.RunDashboardService> services;
        if (service == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(23);
        }
        if ((services = this.getServices(contentSettings = service.getSettings())) == null) {
            return;
        }
        if (!this.isShowInDashboard(contentSettings.getConfiguration()) || !RunManager.getInstance((Project)this.myProject).getAllSettings().contains(contentSettings)) {
            this.myServices.remove(services);
            return;
        }
        if (service instanceof RunDashboardServiceImpl) {
            RunDashboardServiceImpl mainService = (RunDashboardServiceImpl)service;
            Content content = services.size() > 1 ? services.remove(1).getContent() : null;
            mainService.setContent(content);
        } else {
            services.remove(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RunDashboardManager.RunDashboardService findService(@NotNull Content content) {
        if (content == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(24);
        }
        this.myServiceLock.readLock().lock();
        try {
            for (List<RunDashboardManager.RunDashboardService> services : this.myServices) {
                for (RunDashboardManager.RunDashboardService service : services) {
                    if (!content.equals(service.getContent())) continue;
                    RunDashboardManager.RunDashboardService runDashboardService = service;
                    return runDashboardService;
                }
            }
        }
        finally {
            this.myServiceLock.readLock().unlock();
            this.updateDashboard(true);
        }
        return null;
    }

    @Nullable
    private RunnerAndConfigurationSettings findSettings(@NotNull Content content) {
        RunnerAndConfigurationSettings baseSettings;
        RunContentDescriptor descriptor;
        if (content == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(25);
        }
        if ((descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content)) == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = this.findSettings(descriptor);
        if (settings == null) {
            return null;
        }
        RunConfiguration baseConfiguration = RunDashboardManagerImpl.getBaseConfiguration(settings.getConfiguration());
        if (baseConfiguration != null && (baseSettings = RunManager.getInstance((Project)this.myProject).findSettings(baseConfiguration)) != null) {
            return baseSettings;
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private RunnerAndConfigurationSettings findSettings(@NotNull RunContentDescriptor descriptor) {
        Set environments;
        ExecutionEnvironment environment;
        if (descriptor == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(26);
        }
        if ((environment = (ExecutionEnvironment)ContainerUtil.getFirstItem((Collection)(environments = ExecutionManagerImpl.getInstance((Project)this.myProject).getExecutionEnvironments(descriptor)))) == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = environment.getRunnerAndConfigurationSettings();
        if (settings != null) {
            return settings;
        }
        RunProfile runProfile = environment.getRunProfile();
        if (!(runProfile instanceof RunConfiguration)) {
            return null;
        }
        RunConfiguration runConfiguration = (RunConfiguration)runProfile;
        this.myServiceLock.readLock().lock();
        try {
            for (List<RunDashboardManager.RunDashboardService> services : this.myServices) {
                for (RunDashboardManager.RunDashboardService service : services) {
                    if (!runConfiguration.equals(service.getSettings().getConfiguration())) continue;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings = service.getSettings();
                    return runnerAndConfigurationSettings;
                }
            }
        }
        finally {
            this.myServiceLock.readLock().unlock();
        }
        return new RunnerAndConfigurationSettingsImpl(RunManagerImpl.getInstanceImpl((Project)this.myProject), runConfiguration);
    }

    @Nullable
    private List<RunDashboardManager.RunDashboardService> getServices(@NotNull RunnerAndConfigurationSettings settings) {
        if (settings == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(27);
        }
        for (List<RunDashboardManager.RunDashboardService> services : this.myServices) {
            if (!services.get(0).getSettings().equals(settings)) continue;
            return services;
        }
        return null;
    }

    private static boolean updateServiceSettings(List<? extends List<RunDashboardManager.RunDashboardService>> newServiceList, List<RunDashboardManager.RunDashboardService> oldServices) {
        RunDashboardManager.RunDashboardService oldService = oldServices.get(0);
        RunnerAndConfigurationSettings oldSettings = oldService.getSettings();
        for (List<RunDashboardManager.RunDashboardService> list : newServiceList) {
            RunnerAndConfigurationSettings newSettings = list.get(0).getSettings();
            if (!newSettings.getType().equals(oldSettings.getType()) || !newSettings.getName().equals(oldSettings.getName())) continue;
            list.remove(0);
            list.add(0, new RunDashboardServiceImpl(newSettings, oldService.getContent()));
            for (int i = 1; i < oldServices.size(); ++i) {
                RunDashboardServiceImpl newService = new RunDashboardServiceImpl(newSettings, oldServices.get(i).getContent());
                list.add(newService);
            }
            return true;
        }
        return false;
    }

    private static void updateContentToolbar(Content content, boolean visible) {
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
        RunnerLayoutUiImpl ui = RunDashboardManagerImpl.getRunnerLayoutUi(descriptor);
        if (ui != null) {
            if (!ServiceViewUIUtils.isNewServicesUIEnabled()) {
                ui.setLeftToolbarVisible(visible);
            }
            ui.setContentToolbarBefore(visible);
        } else {
            ActionToolbar toolbar = RunDashboardManagerImpl.findActionToolbar(descriptor);
            if (toolbar != null) {
                toolbar.getComponent().setVisible(visible);
            }
        }
    }

    void setSelectedContent(@NotNull Content content) {
        ContentManager contentManager;
        if (content == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(28);
        }
        if ((contentManager = content.getManager()) == null || content == contentManager.getSelectedContent()) {
            return;
        }
        if (contentManager != this.myContentManager) {
            contentManager.setSelectedContent(content);
            return;
        }
        this.myContentManager.removeContentManagerListener(this.myServiceContentManagerListener);
        this.myContentManager.setSelectedContent(content);
        RunDashboardManagerImpl.updateContentToolbar(content, false);
        this.myContentManager.addContentManagerListener(this.myServiceContentManagerListener);
    }

    void removeFromSelection(@NotNull Content content) {
        ContentManager contentManager;
        if (content == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(29);
        }
        if ((contentManager = content.getManager()) == null || content != contentManager.getSelectedContent()) {
            return;
        }
        if (contentManager != this.myContentManager) {
            contentManager.removeFromSelection(content);
            return;
        }
        this.myContentManager.removeContentManagerListener(this.myServiceContentManagerListener);
        this.myContentManager.removeFromSelection(content);
        this.myContentManager.addContentManagerListener(this.myServiceContentManagerListener);
    }

    @NotNull
    public RunDashboardStatusFilter getStatusFilter() {
        RunDashboardStatusFilter runDashboardStatusFilter = this.myStatusFilter;
        if (runDashboardStatusFilter == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(30);
        }
        return runDashboardStatusFilter;
    }

    @Nullable
    static RunnerLayoutUiImpl getRunnerLayoutUi(@Nullable RunContentDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        RunnerLayoutUi layoutUi = descriptor.getRunnerLayoutUi();
        return layoutUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)layoutUi : null;
    }

    @Nullable
    static ActionToolbar findActionToolbar(@Nullable RunContentDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        for (Component component : descriptor.getComponent().getComponents()) {
            if (!(component instanceof ActionToolbar)) continue;
            return (ActionToolbar)component;
        }
        return null;
    }

    Set<String> getEnableByDefaultTypes() {
        HashSet<String> result = new HashSet<String>();
        for (RunDashboardDefaultTypesProvider provider : DEFAULT_TYPES_PROVIDER_EP_NAME.getExtensionList()) {
            result.addAll(provider.getDefaultTypeIds(this.myProject));
        }
        return result;
    }

    JComponent getEmptyContent() {
        if (this.myEmptyContent == null) {
            JBPanelWithEmptyText textPanel = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"run.dashboard.configurations.message", (Object[])new Object[0]));
            textPanel.setFocusable(true);
            JComponent wrapped = UiDataProvider.wrapComponent((JComponent)textPanel, sink -> sink.set(PlatformDataKeys.TREE_EXPANDER_HIDE_ACTIONS_IF_NO_EXPANDER, (Object)true));
            NonOpaquePanel mainPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
            mainPanel.add((Component)wrapped, "Center");
            RunDashboardManagerImpl.setupToolbar((JPanel)mainPanel, wrapped, this.myProject);
            this.myEmptyContent = mainPanel;
        }
        return this.myEmptyContent;
    }

    RunDashboardTypePanel getTypeContent() {
        if (this.myTypeContent == null) {
            this.myTypeContent = new RunDashboardTypePanel(this.myProject);
        }
        return this.myTypeContent;
    }

    static void setupToolbar(@NotNull JPanel mainPanel, @NotNull JComponent component, @NotNull Project project) {
        AnAction anAction;
        if (mainPanel == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(31);
        }
        if (component == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(32);
        }
        if (project == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(33);
        }
        if (ServiceViewUIUtils.isNewServicesUIEnabled() && (anAction = ActionManager.getInstance().getAction("RunDashboardContentToolbar")) instanceof ActionGroup) {
            ActionGroup group = (ActionGroup)anAction;
            group.registerCustomShortcutSet(component, (Disposable)project);
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ServicesToolbar", group, true);
            toolbar.setTargetComponent(component);
            mainPanel.add((Component)ServiceViewUIUtils.wrapServicesAligned((ActionToolbar)toolbar), "North");
            int left = 0;
            int right = 0;
            Border border = toolbar.getComponent().getBorder();
            if (border != null) {
                Insets insets = border.getBorderInsets(toolbar.getComponent());
                left = insets.left;
                right = insets.right;
            }
            toolbar.getComponent().setBorder((Border)JBUI.Borders.empty((int)1, (int)left, (int)0, (int)right));
            component.setBorder(IdeBorderFactory.createBorder((int)2));
        }
        ClientProperty.put((JComponent)mainPanel, (Key)ServiceViewDescriptor.ACTION_HOLDER_KEY, (Object)Boolean.TRUE);
    }

    RunDashboardComponentWrapper getContentWrapper() {
        if (this.myContentWrapper == null) {
            this.myContentWrapper = new RunDashboardComponentWrapper(this.myProject);
            ClientProperty.put((JComponent)((Object)this.myContentWrapper), (Key)ServiceViewDescriptor.ACTION_HOLDER_KEY, (Object)Boolean.TRUE);
        }
        return this.myContentWrapper;
    }

    @NotNull
    public State getState() {
        Set<String> configurations;
        ConfigurationType type;
        this.myState.excludedNewTypes.retainAll(this.myTypes);
        this.myState.hiddenConfigurations.clear();
        for (RunConfiguration runConfiguration : this.myHiddenConfigurations) {
            type = runConfiguration.getType();
            if (!this.myTypes.contains(type.getId())) continue;
            configurations = this.myState.hiddenConfigurations.get(type.getId());
            if (configurations == null) {
                configurations = new HashSet<String>();
                this.myState.hiddenConfigurations.put(type.getId(), configurations);
            }
            configurations.add(runConfiguration.getName());
        }
        this.myState.shownConfigurations.clear();
        for (RunConfiguration runConfiguration : this.myShownConfigurations) {
            type = runConfiguration.getType();
            if (!this.myTypes.contains(type.getId())) continue;
            configurations = this.myState.shownConfigurations.get(type.getId());
            if (configurations == null) {
                configurations = new HashSet<String>();
                this.myState.shownConfigurations.put(type.getId(), configurations);
            }
            configurations.add(runConfiguration.getName());
        }
        this.myState.configurationStatuses.clear();
        for (Map.Entry entry : this.myConfigurationStatuses.entrySet()) {
            RunConfiguration configuration = (RunConfiguration)entry.getKey();
            ConfigurationType type2 = configuration.getType();
            if (!this.myTypes.contains(type2.getId())) continue;
            Map<String, String> configurations2 = this.myState.configurationStatuses.get(type2.getId());
            if (configurations2 == null) {
                configurations2 = new HashMap<String, String>();
                this.myState.configurationStatuses.put(type2.getId(), configurations2);
            }
            configurations2.put(configuration.getName(), ((RunDashboardRunConfigurationStatus)entry.getValue()).getId());
        }
        for (String string : this.myState.excludedNewTypes) {
            Collection<RunConfiguration> hiddenConfigurations = this.getExcludedConfigurations(string, this.myShownConfigurations);
            this.myState.hiddenConfigurations.put(string, new HashSet(ContainerUtil.map(hiddenConfigurations, RunProfile::getName)));
        }
        State state = this.myState;
        if (state == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(34);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            RunDashboardManagerImpl.$$$reportNull$$$0(35);
        }
        this.myState = state;
        this.myTypes.clear();
        this.myTypes.addAll(this.myState.configurationTypes);
        Set<String> enableByDefaultTypes = this.getEnableByDefaultTypes();
        enableByDefaultTypes.removeAll(this.myState.excludedTypes);
        this.myTypes.addAll(enableByDefaultTypes);
        this.myHiddenConfigurations.clear();
        this.myShownConfigurations.clear();
        this.myState.excludedNewTypes.retainAll(this.myTypes);
        if (!this.myTypes.isEmpty()) {
            this.loadStatuses();
            this.loadHiddenConfigurations();
            this.initTypes();
        }
    }

    private void loadHiddenConfigurations() {
        for (Map.Entry<String, Set<String>> entry : this.myState.hiddenConfigurations.entrySet()) {
            if (this.myState.excludedNewTypes.contains(entry.getKey())) continue;
            this.loadConfigurations(entry.getKey(), entry.getValue(), this.myHiddenConfigurations);
        }
        for (Map.Entry<String, Set<String>> entry : this.myState.shownConfigurations.entrySet()) {
            this.loadConfigurations(entry.getKey(), entry.getValue(), this.myShownConfigurations);
        }
    }

    private void loadConfigurations(String typeId, Set<String> configurationNames, Set<RunConfiguration> result) {
        ConfigurationType type = ConfigurationTypeUtil.findConfigurationType((String)typeId);
        if (type == null) {
            return;
        }
        List configurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList(type);
        result.addAll(ContainerUtil.filter((Collection)configurations, configuration -> configurationNames.contains(configuration.getName())));
    }

    private void loadStatuses() {
        this.myState.configurationStatuses.forEach((typeId, statuses) -> {
            ConfigurationType type = ConfigurationTypeUtil.findConfigurationType((String)typeId);
            if (type == null) {
                return;
            }
            List configurations = RunManager.getInstance((Project)this.myProject).getConfigurationsList(type);
            statuses.forEach((name, statusId) -> {
                RunConfiguration configuration = (RunConfiguration)ContainerUtil.find((Iterable)configurations, it -> it.getName().equals(name));
                if (configuration == null) {
                    return;
                }
                RunDashboardRunConfigurationStatus status = RunDashboardRunConfigurationStatus.getStatusById((String)statusId);
                if (status == null) {
                    return;
                }
                this.myConfigurationStatuses.put(configuration, status);
            });
        });
    }

    private void initTypes() {
        this.syncConfigurations();
        this.initServiceContentListeners();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (!this.myProject.isDisposed()) {
                this.updateDashboard(true);
            }
        });
    }

    public void noStateLoaded() {
        this.myTypes.clear();
        if (this.myProject.isDefault()) {
            this.myTypes.addAll(this.getEnableByDefaultTypes());
        } else {
            this.myTypes.addAll(RunDashboardManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).getTypes());
        }
        if (!this.myTypes.isEmpty()) {
            this.initTypes();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 6, 11, 14, 20, 21, 22, 30, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 10: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainPanel";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindowIcon";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomizers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getReuseCondition";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "doAddServiceContent";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusFilter";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 34: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isShowInDashboard";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isShown";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getBaseConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setTypes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearConfigurationStatus";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPersistedStatus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getCustomizers";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateDashboardIfNeeded";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationDescriptors";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addServiceContent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeServiceContent";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateServiceContent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doAddServiceContent";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doRemoveServiceContent";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findService";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findSettings";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getServices";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedContent";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "removeFromSelection";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "setupToolbar";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 6, 11, 14, 20, 21, 22, 30, 34 -> new IllegalStateException(string);
        };
    }

    static final class State {
        public final Set<String> configurationTypes = new HashSet<String>();
        public final Set<String> excludedTypes = new HashSet<String>();
        public final Map<String, Set<String>> hiddenConfigurations = new HashMap<String, Set<String>>();
        public final Map<String, Set<String>> shownConfigurations = new HashMap<String, Set<String>>();
        public final Map<String, Map<String, String>> configurationStatuses = new HashMap<String, Map<String, String>>();
        public final Set<String> excludedNewTypes = new HashSet<String>();
        public boolean openRunningConfigInTab = false;

        State() {
        }
    }

    private final class ServiceContentManagerListener
    implements ContentManagerListener {
        private volatile Content myPreviousSelection = null;

        private ServiceContentManagerListener() {
        }

        public void selectionChanged(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ServiceContentManagerListener.$$$reportNull$$$0(0);
            }
            boolean onAdd = event.getOperation() == ContentManagerEvent.ContentOperation.add;
            Content content = event.getContent();
            if (onAdd) {
                RunDashboardManagerImpl.updateContentToolbar(content, false);
                RunDashboardManagerImpl.this.updateServiceContent(content);
            }
            RunDashboardManagerImpl.this.updateDashboard(true);
            if (onAdd) {
                RunDashboardManager.RunDashboardService service = RunDashboardManagerImpl.this.findService(content);
                if (service != null) {
                    RunConfigurationNode node = this.createNode(service);
                    RunnerAndConfigurationSettings settings = node.getConfigurationSettings();
                    ((ServiceViewManagerImpl)ServiceViewManager.getInstance((Project)RunDashboardManagerImpl.this.myProject)).trackingSelect((Object)node, RunDashboardServiceViewContributor.class, settings.isActivateToolWindowBeforeRun(), settings.isFocusToolWindowBeforeRun()).onSuccess(selected -> {
                        if (selected != Boolean.TRUE) {
                            this.selectPreviousContent();
                        }
                    }).onError(t -> this.selectPreviousContent());
                }
            } else {
                this.myPreviousSelection = content;
            }
        }

        private void selectPreviousContent() {
            Content previousSelection = this.myPreviousSelection;
            if (previousSelection != null) {
                ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith((Disposable)previousSelection)).submit(() -> RunDashboardManagerImpl.this.setSelectedContent(previousSelection));
            }
        }

        public void contentAdded(@NotNull ContentManagerEvent event) {
            if (event == null) {
                ServiceContentManagerListener.$$$reportNull$$$0(1);
            }
            Content content = event.getContent();
            RunDashboardManager.RunDashboardService service = RunDashboardManagerImpl.this.addServiceContent(content);
            if (RunDashboardManagerImpl.this.myState.openRunningConfigInTab && service != null) {
                ServiceViewManager.getInstance((Project)RunDashboardManagerImpl.this.myProject).extract((Object)this.createNode(service), RunDashboardServiceViewContributor.class);
            }
        }

        public void contentRemoved(@NotNull ContentManagerEvent event) {
            Content content;
            if (event == null) {
                ServiceContentManagerListener.$$$reportNull$$$0(2);
            }
            if (this.myPreviousSelection == (content = event.getContent())) {
                this.myPreviousSelection = null;
            }
            RunDashboardManagerImpl.this.removeServiceContent(content);
        }

        private RunConfigurationNode createNode(RunDashboardManager.RunDashboardService service) {
            return new RunConfigurationNode(RunDashboardManagerImpl.this.myProject, service, RunDashboardManagerImpl.getCustomizers(service.getSettings(), service.getDescriptor()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$ServiceContentManagerListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "selectionChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentAdded";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RunDashboardServiceImpl
    implements RunDashboardManager.RunDashboardService {
        private final RunnerAndConfigurationSettings mySettings;
        private Content myContent;

        RunDashboardServiceImpl(@NotNull RunnerAndConfigurationSettings settings, @Nullable Content content) {
            if (settings == null) {
                RunDashboardServiceImpl.$$$reportNull$$$0(0);
            }
            this.mySettings = settings;
            this.myContent = content;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                RunDashboardServiceImpl.$$$reportNull$$$0(1);
            }
            return runnerAndConfigurationSettings;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            Content content = this.myContent;
            return content == null ? null : RunContentManagerImpl.getRunContentDescriptorByContent((Content)content);
        }

        @Nullable
        public Content getContent() {
            return this.myContent;
        }

        void setContent(@Nullable Content content) {
            this.myContent = content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RunDashboardServiceImpl service = (RunDashboardServiceImpl)o;
            return this.mySettings.equals(service.mySettings);
        }

        public int hashCode() {
            return this.mySettings.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$RunDashboardServiceImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$RunDashboardServiceImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class AdditionalRunDashboardService
    implements RunDashboardManager.RunDashboardService {
        private final RunnerAndConfigurationSettings mySettings;
        private final Content myContent;

        AdditionalRunDashboardService(@NotNull RunnerAndConfigurationSettings settings, @NotNull Content content) {
            if (settings == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(0);
            }
            if (content == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(1);
            }
            this.mySettings = settings;
            this.myContent = content;
        }

        @NotNull
        public RunnerAndConfigurationSettings getSettings() {
            RunnerAndConfigurationSettings runnerAndConfigurationSettings = this.mySettings;
            if (runnerAndConfigurationSettings == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(2);
            }
            return runnerAndConfigurationSettings;
        }

        @Nullable
        public RunContentDescriptor getDescriptor() {
            return RunContentManagerImpl.getRunContentDescriptorByContent((Content)this.myContent);
        }

        @NotNull
        public Content getContent() {
            Content content = this.myContent;
            if (content == null) {
                AdditionalRunDashboardService.$$$reportNull$$$0(3);
            }
            return content;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdditionalRunDashboardService service = (AdditionalRunDashboardService)o;
            return this.mySettings.equals(service.mySettings) && Comparing.equal((Object)this.myContent, (Object)service.myContent);
        }

        public int hashCode() {
            int result = this.mySettings.hashCode();
            result = 31 * result + this.myContent.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$AdditionalRunDashboardService";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/platform/execution/dashboard/RunDashboardManagerImpl$AdditionalRunDashboardService";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

