/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner.events;

import com.intellij.openapi.util.text.Strings;
import com.intellij.util.JavaXmlDocumentKt;
import java.io.StringReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventXmlView;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class TestEventXmlXPathView
implements TestEventXmlView {
    private final XPath xpath = XPathFactory.newDefaultInstance().newXPath();
    private final Document xmlDocument;

    public TestEventXmlXPathView(String xml) throws TestEventXmlView.XmlParserException {
        try {
            InputSource is = new InputSource(new StringReader(xml));
            this.xmlDocument = JavaXmlDocumentKt.createDocumentBuilder().parse(is);
        }
        catch (Exception ex) {
            throw new TestEventXmlView.XmlParserException(ex);
        }
    }

    @Override
    @NotNull
    public String getTestEventType() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/@type");
    }

    @Override
    @NotNull
    public String getTestName() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/descriptor/@name");
    }

    @Override
    @NotNull
    public String getTestDisplayName() throws TestEventXmlView.XmlParserException {
        String displayName = this.queryXml("/ijLog/event/test/descriptor/@displayName");
        String string = Strings.isEmpty((String)displayName) ? this.getTestName() : displayName;
        if (string == null) {
            TestEventXmlXPathView.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getTestParentId() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/@parentId");
    }

    @Override
    @NotNull
    public String getTestId() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/@id");
    }

    @Override
    @NotNull
    public String getTestClassName() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/descriptor/@className");
    }

    @Override
    @NotNull
    public String getTestEventResultType() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/@resultType");
    }

    @Override
    @NotNull
    public String getEventTitle() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/title");
    }

    @Override
    public boolean isEventOpenSettings() throws TestEventXmlView.XmlParserException {
        return Boolean.parseBoolean(this.queryXml("/ijLog/event/@openSettings"));
    }

    @Override
    @NotNull
    public String getEventMessage() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/message");
    }

    @Override
    @NotNull
    public String getTestEventTest() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/event");
    }

    @Override
    @NotNull
    public String getTestEventTestDescription() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/event/@destination");
    }

    @Override
    @NotNull
    public String getEventTestReport() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/@testReport");
    }

    @Override
    @NotNull
    public String getEventTestResultActualFilePath() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/actualFilePath");
    }

    @Override
    @NotNull
    public String getEventTestResultFilePath() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/filePath");
    }

    @Override
    @NotNull
    public String getEventTestResultExpected() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/expected");
    }

    @Override
    @NotNull
    public String getEventTestResultActual() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/actual");
    }

    @Override
    @NotNull
    public String getEventTestResultFailureType() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/failureType");
    }

    @Override
    @NotNull
    public String getEventTestResultExceptionName() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/exceptionName");
    }

    @Override
    @NotNull
    public String getEventTestResultStackTrace() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/stackTrace");
    }

    @Override
    @NotNull
    public String getEventTestResultErrorMsg() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/errorMsg");
    }

    @Override
    @NotNull
    public String getEventTestResultEndTime() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/@endTime");
    }

    @Override
    @NotNull
    public String getEventTestResultStartTime() throws TestEventXmlView.XmlParserException {
        return this.queryXml("/ijLog/event/test/result/@startTime");
    }

    @NotNull
    private String queryXml(String xpathExpr) throws TestEventXmlView.XmlParserException {
        String string;
        try {
            string = this.xmlDocument == null ? "" : this.xpath.evaluate(xpathExpr, this.xmlDocument);
        }
        catch (XPathExpressionException ex) {
            throw new TestEventXmlView.XmlParserException(ex);
        }
        if (string == null) {
            TestEventXmlXPathView.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/gradle/execution/test/runner/events/TestEventXmlXPathView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "queryXml";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

