/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.com.google.common.base.Preconditions;
import org.jetbrains.kotlin.com.google.common.collect.UnmodifiableIterator;

class MapIteratorCache<K, V> {
    private final Map<K, V> backingMap;
    private transient Map.Entry<K, V> entrySetCache;

    MapIteratorCache(Map<K, V> backingMap) {
        this.backingMap = Preconditions.checkNotNull(backingMap);
    }

    public V put(K key, V value) {
        this.clearCache();
        return this.backingMap.put(key, value);
    }

    public V remove(Object key) {
        this.clearCache();
        return this.backingMap.remove(key);
    }

    public void clear() {
        this.clearCache();
        this.backingMap.clear();
    }

    public V get(Object key) {
        V value = this.getIfCached(key);
        return value != null ? value : this.getWithoutCaching(key);
    }

    public final V getWithoutCaching(Object key) {
        return this.backingMap.get(key);
    }

    public final boolean containsKey(Object key) {
        return this.getIfCached(key) != null || this.backingMap.containsKey(key);
    }

    public final Set<K> unmodifiableKeySet() {
        return new AbstractSet<K>(){

            @Override
            public UnmodifiableIterator<K> iterator() {
                final Iterator entryIterator = MapIteratorCache.this.backingMap.entrySet().iterator();
                return new UnmodifiableIterator<K>(){

                    @Override
                    public boolean hasNext() {
                        return entryIterator.hasNext();
                    }

                    @Override
                    public K next() {
                        Map.Entry entry = (Map.Entry)entryIterator.next();
                        MapIteratorCache.this.entrySetCache = entry;
                        return entry.getKey();
                    }
                };
            }

            @Override
            public int size() {
                return MapIteratorCache.this.backingMap.size();
            }

            @Override
            public boolean contains(Object key) {
                return MapIteratorCache.this.containsKey(key);
            }
        };
    }

    protected V getIfCached(Object key) {
        Map.Entry<K, V> entry = this.entrySetCache;
        if (entry != null && entry.getKey() == key) {
            return entry.getValue();
        }
        return null;
    }

    protected void clearCache() {
        this.entrySetCache = null;
    }
}

